/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.registry;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Wtsapi32;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.wmi.Win32Process;
import oshi.jna.ByRef;
import oshi.util.platform.windows.WmiUtil;

@ThreadSafe
public final class ProcessWtsData {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWtsData.class);
    private static final boolean IS_WINDOWS7_OR_GREATER = VersionHelpers.IsWindows7OrGreater();

    private ProcessWtsData() {
    }

    public static Map<Integer, WtsInfo> queryProcessWtsMap(Collection<Integer> collection) {
        if (IS_WINDOWS7_OR_GREATER) {
            return ProcessWtsData.queryProcessWtsMapFromWTS(collection);
        }
        return ProcessWtsData.queryProcessWtsMapFromPerfMon(collection);
    }

    private static Map<Integer, WtsInfo> queryProcessWtsMapFromWTS(Collection<Integer> collection) {
        HashMap<Integer, WtsInfo> hashMap = new HashMap<Integer, WtsInfo>();
        try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference(0);
             ByRef.CloseablePointerByReference closeablePointerByReference = new ByRef.CloseablePointerByReference();
             ByRef.CloseableIntByReference closeableIntByReference2 = new ByRef.CloseableIntByReference(1);){
            Wtsapi32.WTS_PROCESS_INFO_EX[] wTS_PROCESS_INFO_EXArray;
            if (!Wtsapi32.INSTANCE.WTSEnumerateProcessesEx(Wtsapi32.WTS_CURRENT_SERVER_HANDLE, closeableIntByReference2, -2, closeablePointerByReference, closeableIntByReference)) {
                LOG.error("Failed to enumerate Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                HashMap<Integer, WtsInfo> hashMap2 = hashMap;
                return hashMap2;
            }
            Pointer pointer = closeablePointerByReference.getValue();
            Wtsapi32.WTS_PROCESS_INFO_EX wTS_PROCESS_INFO_EX = new Wtsapi32.WTS_PROCESS_INFO_EX(pointer);
            for (Wtsapi32.WTS_PROCESS_INFO_EX wTS_PROCESS_INFO_EX2 : wTS_PROCESS_INFO_EXArray = (Wtsapi32.WTS_PROCESS_INFO_EX[])wTS_PROCESS_INFO_EX.toArray(closeableIntByReference.getValue())) {
                if (collection != null && !collection.contains(wTS_PROCESS_INFO_EX2.ProcessId)) continue;
                hashMap.put(wTS_PROCESS_INFO_EX2.ProcessId, new WtsInfo(wTS_PROCESS_INFO_EX2.pProcessName, "", wTS_PROCESS_INFO_EX2.NumberOfThreads, (long)wTS_PROCESS_INFO_EX2.PagefileUsage & 0xFFFFFFFFL, wTS_PROCESS_INFO_EX2.KernelTime.getValue() / 10000L, wTS_PROCESS_INFO_EX2.UserTime.getValue() / 10000L, wTS_PROCESS_INFO_EX2.HandleCount));
            }
            if (!Wtsapi32.INSTANCE.WTSFreeMemoryEx(1, pointer, closeableIntByReference.getValue())) {
                LOG.warn("Failed to Free Memory for Processes. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            }
        }
        return hashMap;
    }

    private static Map<Integer, WtsInfo> queryProcessWtsMapFromPerfMon(Collection<Integer> collection) {
        HashMap<Integer, WtsInfo> hashMap = new HashMap<Integer, WtsInfo>();
        WbemcliUtil.WmiResult<Win32Process.ProcessXPProperty> wmiResult = Win32Process.queryProcesses(collection);
        for (int i = 0; i < wmiResult.getResultCount(); ++i) {
            hashMap.put(WmiUtil.getUint32(wmiResult, Win32Process.ProcessXPProperty.PROCESSID, i), new WtsInfo(WmiUtil.getString(wmiResult, Win32Process.ProcessXPProperty.NAME, i), WmiUtil.getString(wmiResult, Win32Process.ProcessXPProperty.EXECUTABLEPATH, i), WmiUtil.getUint32(wmiResult, Win32Process.ProcessXPProperty.THREADCOUNT, i), 1024L * ((long)WmiUtil.getUint32(wmiResult, Win32Process.ProcessXPProperty.PAGEFILEUSAGE, i) & 0xFFFFFFFFL), WmiUtil.getUint64(wmiResult, Win32Process.ProcessXPProperty.KERNELMODETIME, i) / 10000L, WmiUtil.getUint64(wmiResult, Win32Process.ProcessXPProperty.USERMODETIME, i) / 10000L, WmiUtil.getUint32(wmiResult, Win32Process.ProcessXPProperty.HANDLECOUNT, i)));
        }
        return hashMap;
    }

    @Immutable
    public static class WtsInfo {
        private final String name;
        private final String path;
        private final int threadCount;
        private final long virtualSize;
        private final long kernelTime;
        private final long userTime;
        private final long openFiles;

        public WtsInfo(String string, String string2, int n, long l, long l2, long l3, long l4) {
            this.name = string;
            this.path = string2;
            this.threadCount = n;
            this.virtualSize = l;
            this.kernelTime = l2;
            this.userTime = l3;
            this.openFiles = l4;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public int getThreadCount() {
            return this.threadCount;
        }

        public long getVirtualSize() {
            return this.virtualSize;
        }

        public long getKernelTime() {
            return this.kernelTime;
        }

        public long getUserTime() {
            return this.userTime;
        }

        public long getOpenFiles() {
            return this.openFiles;
        }
    }
}

