/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;

@ThreadSafe
public interface CentralProcessor {
    public ProcessorIdentifier getProcessorIdentifier();

    public long getMaxFreq();

    public long[] getCurrentFreq();

    public List<LogicalProcessor> getLogicalProcessors();

    public List<PhysicalProcessor> getPhysicalProcessors();

    public List<ProcessorCache> getProcessorCaches();

    public double getSystemCpuLoadBetweenTicks(long[] var1);

    public long[] getSystemCpuLoadTicks();

    public double[] getSystemLoadAverage(int var1);

    default public double getSystemCpuLoad(long l) {
        long l2 = System.nanoTime();
        long[] lArray = this.getSystemCpuLoadTicks();
        long l3 = l - (System.nanoTime() - l2) / 1000000L;
        if (l3 > 0L) {
            Util.sleep(l);
        }
        return this.getSystemCpuLoadBetweenTicks(lArray);
    }

    default public double[] getProcessorCpuLoad(long l) {
        long l2 = System.nanoTime();
        long[][] lArray = this.getProcessorCpuLoadTicks();
        long l3 = l - (System.nanoTime() - l2) / 1000000L;
        if (l3 > 0L) {
            Util.sleep(l);
        }
        return this.getProcessorCpuLoadBetweenTicks(lArray);
    }

    public double[] getProcessorCpuLoadBetweenTicks(long[][] var1);

    public long[][] getProcessorCpuLoadTicks();

    public int getLogicalProcessorCount();

    public int getPhysicalProcessorCount();

    public int getPhysicalPackageCount();

    public long getContextSwitches();

    public long getInterrupts();

    @Immutable
    public static final class ProcessorIdentifier {
        private static final String OSHI_ARCHITECTURE_PROPERTIES = "oshi.architecture.properties";
        private final String cpuVendor;
        private final String cpuName;
        private final String cpuFamily;
        private final String cpuModel;
        private final String cpuStepping;
        private final String processorID;
        private final String cpuIdentifier;
        private final boolean cpu64bit;
        private final long cpuVendorFreq;
        private final Supplier<String> microArchictecture = Memoizer.memoize(this::queryMicroarchitecture);

        public ProcessorIdentifier(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
            this(string, string2, string3, string4, string5, string6, bl, -1L);
        }

        public ProcessorIdentifier(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, long l) {
            this.cpuVendor = string.startsWith("0x") ? this.queryVendorFromImplementer(string) : string;
            this.cpuName = string2;
            this.cpuFamily = string3;
            this.cpuModel = string4;
            this.cpuStepping = string5;
            this.processorID = string6;
            this.cpu64bit = bl;
            StringBuilder stringBuilder = new StringBuilder();
            if (string.contentEquals("GenuineIntel")) {
                stringBuilder.append(bl ? "Intel64" : "x86");
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append(" Family ").append(string3);
            stringBuilder.append(" Model ").append(string4);
            stringBuilder.append(" Stepping ").append(string5);
            this.cpuIdentifier = stringBuilder.toString();
            if (l > 0L) {
                this.cpuVendorFreq = l;
            } else {
                Pattern pattern = Pattern.compile("@ (.*)$");
                Matcher matcher = pattern.matcher(string2);
                if (matcher.find()) {
                    String string7 = matcher.group(1);
                    this.cpuVendorFreq = ParseUtil.parseHertz(string7);
                } else {
                    this.cpuVendorFreq = -1L;
                }
            }
        }

        public String getVendor() {
            return this.cpuVendor;
        }

        public String getName() {
            return this.cpuName;
        }

        public String getFamily() {
            return this.cpuFamily;
        }

        public String getModel() {
            return this.cpuModel;
        }

        public String getStepping() {
            return this.cpuStepping;
        }

        public String getProcessorID() {
            return this.processorID;
        }

        public String getIdentifier() {
            return this.cpuIdentifier;
        }

        public boolean isCpu64bit() {
            return this.cpu64bit;
        }

        public long getVendorFreq() {
            return this.cpuVendorFreq;
        }

        public String getMicroarchitecture() {
            return this.microArchictecture.get();
        }

        private String queryMicroarchitecture() {
            String string = null;
            Properties properties = FileUtil.readPropertiesFromFilename(OSHI_ARCHITECTURE_PROPERTIES);
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = this.cpuVendor.toUpperCase(Locale.ROOT);
            if (string2.contains("AMD")) {
                stringBuilder.append("amd.");
            } else if (string2.contains("ARM")) {
                stringBuilder.append("arm.");
            } else if (string2.contains("IBM")) {
                int n = this.cpuName.indexOf("_POWER");
                if (n > 0) {
                    string = this.cpuName.substring(n + 1);
                }
            } else if (string2.contains("APPLE")) {
                stringBuilder.append("apple.");
            }
            if (Util.isBlank(string) && !stringBuilder.toString().equals("arm.")) {
                stringBuilder.append(this.cpuFamily);
                string = properties.getProperty(stringBuilder.toString());
            }
            if (Util.isBlank(string)) {
                stringBuilder.append('.').append(this.cpuModel);
                string = properties.getProperty(stringBuilder.toString());
            }
            if (Util.isBlank(string)) {
                stringBuilder.append('.').append(this.cpuStepping);
                string = properties.getProperty(stringBuilder.toString());
            }
            return Util.isBlank(string) ? "unknown" : string;
        }

        private String queryVendorFromImplementer(String string) {
            Properties properties = FileUtil.readPropertiesFromFilename(OSHI_ARCHITECTURE_PROPERTIES);
            String string2 = properties.getProperty("hw_impl." + this.cpuVendor);
            return string2 == null ? string : string2;
        }

        public String toString() {
            return this.getIdentifier();
        }
    }

    @Immutable
    public static class ProcessorCache {
        private final byte level;
        private final byte associativity;
        private final short lineSize;
        private final int cacheSize;
        private final Type type;

        public ProcessorCache(byte by, byte by2, short s, int n, Type type) {
            this.level = by;
            this.associativity = by2;
            this.lineSize = s;
            this.cacheSize = n;
            this.type = type;
        }

        public ProcessorCache(int n, int n2, int n3, long l, Type type) {
            this((byte)n, (byte)n2, (short)n3, (int)l, type);
        }

        public byte getLevel() {
            return this.level;
        }

        public byte getAssociativity() {
            return this.associativity;
        }

        public short getLineSize() {
            return this.lineSize;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "ProcessorCache [L" + this.level + " " + (Object)((Object)this.type) + ", cacheSize=" + this.cacheSize + ", " + (this.associativity > 0 ? this.associativity + "-way" : "unknown") + " associativity, lineSize=" + this.lineSize + "]";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof ProcessorCache)) {
                return false;
            }
            ProcessorCache processorCache = (ProcessorCache)object;
            return this.associativity == processorCache.associativity && this.cacheSize == processorCache.cacheSize && this.level == processorCache.level && this.lineSize == processorCache.lineSize && this.type == processorCache.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.associativity, this.cacheSize, this.level, this.lineSize, this.type});
        }

        public static enum Type {
            UNIFIED,
            INSTRUCTION,
            DATA,
            TRACE;


            public String toString() {
                return this.name().substring(0, 1) + this.name().substring(1).toLowerCase(Locale.ROOT);
            }
        }
    }

    @Immutable
    public static class PhysicalProcessor {
        private final int physicalPackageNumber;
        private final int physicalProcessorNumber;
        private final int efficiency;
        private final String idString;

        public PhysicalProcessor(int n, int n2) {
            this(n, n2, 0, "");
        }

        public PhysicalProcessor(int n, int n2, int n3, String string) {
            this.physicalPackageNumber = n;
            this.physicalProcessorNumber = n2;
            this.efficiency = n3;
            this.idString = string;
        }

        public int getPhysicalPackageNumber() {
            return this.physicalPackageNumber;
        }

        public int getPhysicalProcessorNumber() {
            return this.physicalProcessorNumber;
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        public String getIdString() {
            return this.idString;
        }

        public String toString() {
            return "PhysicalProcessor [package/core=" + this.physicalPackageNumber + "/" + this.physicalProcessorNumber + ", efficiency=" + this.efficiency + ", idString=" + this.idString + "]";
        }
    }

    @Immutable
    public static class LogicalProcessor {
        private final int processorNumber;
        private final int physicalProcessorNumber;
        private final int physicalPackageNumber;
        private final int numaNode;
        private final int processorGroup;

        public LogicalProcessor(int n, int n2, int n3) {
            this(n, n2, n3, 0, 0);
        }

        public LogicalProcessor(int n, int n2, int n3, int n4) {
            this(n, n2, n3, n4, 0);
        }

        public LogicalProcessor(int n, int n2, int n3, int n4, int n5) {
            this.processorNumber = n;
            this.physicalProcessorNumber = n2;
            this.physicalPackageNumber = n3;
            this.numaNode = n4;
            this.processorGroup = n5;
        }

        public int getProcessorNumber() {
            return this.processorNumber;
        }

        public int getPhysicalProcessorNumber() {
            return this.physicalProcessorNumber;
        }

        public int getPhysicalPackageNumber() {
            return this.physicalPackageNumber;
        }

        public int getNumaNode() {
            return this.numaNode;
        }

        public int getProcessorGroup() {
            return this.processorGroup;
        }

        public String toString() {
            return "LogicalProcessor [processorNumber=" + this.processorNumber + ", coreNumber=" + this.physicalProcessorNumber + ", packageNumber=" + this.physicalPackageNumber + ", numaNode=" + this.numaNode + ", processorGroup=" + this.processorGroup + "]";
        }
    }

    public static enum TickType {
        USER(0),
        NICE(1),
        SYSTEM(2),
        IDLE(3),
        IOWAIT(4),
        IRQ(5),
        SOFTIRQ(6),
        STEAL(7);

        private final int index;

        private TickType(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

