/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.bootstrap;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import pro.gravit.repackage.io.netty.bootstrap.AbstractBootstrap;
import pro.gravit.repackage.io.netty.bootstrap.AbstractBootstrap$PendingRegistrationPromise;
import pro.gravit.repackage.io.netty.bootstrap.Bootstrap$1;
import pro.gravit.repackage.io.netty.bootstrap.Bootstrap$2;
import pro.gravit.repackage.io.netty.bootstrap.Bootstrap$3;
import pro.gravit.repackage.io.netty.bootstrap.Bootstrap$ExternalAddressResolver;
import pro.gravit.repackage.io.netty.bootstrap.BootstrapConfig;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.EventLoopGroup;
import pro.gravit.repackage.io.netty.resolver.AddressResolver;
import pro.gravit.repackage.io.netty.resolver.AddressResolverGroup;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class Bootstrap
extends AbstractBootstrap<Bootstrap, Channel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private final BootstrapConfig config = new BootstrapConfig(this);
    private Bootstrap$ExternalAddressResolver externalResolver;
    private volatile boolean disableResolver;
    private volatile SocketAddress remoteAddress;

    public Bootstrap() {
    }

    private Bootstrap(Bootstrap bootstrap) {
        super(bootstrap);
        this.externalResolver = bootstrap.externalResolver;
        this.disableResolver = bootstrap.disableResolver;
        this.remoteAddress = bootstrap.remoteAddress;
    }

    public Bootstrap resolver(AddressResolverGroup<?> addressResolverGroup) {
        this.externalResolver = addressResolverGroup == null ? null : new Bootstrap$ExternalAddressResolver(addressResolverGroup);
        this.disableResolver = false;
        return this;
    }

    public Bootstrap disableResolver() {
        this.externalResolver = null;
        this.disableResolver = true;
        return this;
    }

    public Bootstrap remoteAddress(SocketAddress socketAddress) {
        this.remoteAddress = socketAddress;
        return this;
    }

    public Bootstrap remoteAddress(String string, int n) {
        this.remoteAddress = InetSocketAddress.createUnresolved(string, n);
        return this;
    }

    public Bootstrap remoteAddress(InetAddress inetAddress, int n) {
        this.remoteAddress = new InetSocketAddress(inetAddress, n);
        return this;
    }

    public ChannelFuture connect() {
        this.validate();
        SocketAddress socketAddress = this.remoteAddress;
        if (socketAddress == null) {
            throw new IllegalStateException("remoteAddress not set");
        }
        return this.doResolveAndConnect(socketAddress, this.config.localAddress());
    }

    public ChannelFuture connect(String string, int n) {
        return this.connect(InetSocketAddress.createUnresolved(string, n));
    }

    public ChannelFuture connect(InetAddress inetAddress, int n) {
        return this.connect(new InetSocketAddress(inetAddress, n));
    }

    public ChannelFuture connect(SocketAddress socketAddress) {
        ObjectUtil.checkNotNull(socketAddress, "remoteAddress");
        this.validate();
        return this.doResolveAndConnect(socketAddress, this.config.localAddress());
    }

    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        ObjectUtil.checkNotNull(socketAddress, "remoteAddress");
        this.validate();
        return this.doResolveAndConnect(socketAddress, socketAddress2);
    }

    private ChannelFuture doResolveAndConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        ChannelFuture channelFuture = this.initAndRegister();
        Channel channel = channelFuture.channel();
        if (channelFuture.isDone()) {
            if (!channelFuture.isSuccess()) {
                return channelFuture;
            }
            return this.doResolveAndConnect0(channel, socketAddress, socketAddress2, channel.newPromise());
        }
        AbstractBootstrap$PendingRegistrationPromise abstractBootstrap$PendingRegistrationPromise = new AbstractBootstrap$PendingRegistrationPromise(channel);
        channelFuture.addListener(new Bootstrap$1(this, abstractBootstrap$PendingRegistrationPromise, channel, socketAddress, socketAddress2));
        return abstractBootstrap$PendingRegistrationPromise;
    }

    private ChannelFuture doResolveAndConnect0(Channel channel, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        try {
            AddressResolver<SocketAddress> addressResolver;
            if (this.disableResolver) {
                Bootstrap.doConnect(socketAddress, socketAddress2, channelPromise);
                return channelPromise;
            }
            EventLoop eventLoop = channel.eventLoop();
            try {
                addressResolver = Bootstrap$ExternalAddressResolver.getOrDefault(this.externalResolver).getResolver(eventLoop);
            }
            catch (Throwable throwable) {
                channel.close();
                return channelPromise.setFailure(throwable);
            }
            if (!addressResolver.isSupported(socketAddress) || addressResolver.isResolved(socketAddress)) {
                Bootstrap.doConnect(socketAddress, socketAddress2, channelPromise);
                return channelPromise;
            }
            Future<SocketAddress> future = addressResolver.resolve(socketAddress);
            if (future.isDone()) {
                Throwable throwable = future.cause();
                if (throwable != null) {
                    channel.close();
                    channelPromise.setFailure(throwable);
                } else {
                    Bootstrap.doConnect(future.getNow(), socketAddress2, channelPromise);
                }
                return channelPromise;
            }
            future.addListener(new Bootstrap$2(this, channel, channelPromise, socketAddress2));
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
        }
        return channelPromise;
    }

    private static void doConnect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        Channel channel = channelPromise.channel();
        channel.eventLoop().execute(new Bootstrap$3(socketAddress2, channel, socketAddress, channelPromise));
    }

    @Override
    void init(Channel channel) {
        ChannelPipeline channelPipeline = channel.pipeline();
        channelPipeline.addLast(this.config.handler());
        Bootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        Bootstrap.setAttributes(channel, this.newAttributesArray());
    }

    @Override
    public Bootstrap validate() {
        super.validate();
        if (this.config.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
        return this;
    }

    @Override
    public Bootstrap clone() {
        return new Bootstrap(this);
    }

    public Bootstrap clone(EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = new Bootstrap(this);
        bootstrap.group = eventLoopGroup;
        return bootstrap;
    }

    public final BootstrapConfig config() {
        return this.config;
    }

    final SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    final AddressResolverGroup<?> resolver() {
        if (this.disableResolver) {
            return null;
        }
        return Bootstrap$ExternalAddressResolver.getOrDefault(this.externalResolver);
    }

    static /* synthetic */ ChannelFuture access$000(Bootstrap bootstrap, Channel channel, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return bootstrap.doResolveAndConnect0(channel, socketAddress, socketAddress2, channelPromise);
    }

    static /* synthetic */ void access$100(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        Bootstrap.doConnect(socketAddress, socketAddress2, channelPromise);
    }
}

