/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

final class ByteBufUtil$HexUtil {
    private static final char[] BYTE2CHAR;
    private static final char[] HEXDUMP_TABLE;
    private static final String[] HEXPADDING;
    private static final String[] HEXDUMP_ROWPREFIXES;
    private static final String[] BYTE2HEX;
    private static final String[] BYTEPADDING;

    private ByteBufUtil$HexUtil() {
    }

    private static String hexDump(ByteBuf byteBuf, int n, int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "length");
        if (n2 == 0) {
            return "";
        }
        int n3 = n + n2;
        char[] cArray = new char[n2 << 1];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3) {
            System.arraycopy(HEXDUMP_TABLE, byteBuf.getUnsignedByte(n4) << 1, cArray, n5, 2);
            ++n4;
            n5 += 2;
        }
        return new String(cArray);
    }

    private static String hexDump(byte[] byArray, int n, int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "length");
        if (n2 == 0) {
            return "";
        }
        int n3 = n + n2;
        char[] cArray = new char[n2 << 1];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3) {
            System.arraycopy(HEXDUMP_TABLE, (byArray[n4] & 0xFF) << 1, cArray, n5, 2);
            ++n4;
            n5 += 2;
        }
        return new String(cArray);
    }

    private static String prettyHexDump(ByteBuf byteBuf, int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        int n3 = n2 / 16 + ((n2 & 0xF) == 0 ? 0 : 1) + 4;
        StringBuilder stringBuilder = new StringBuilder(n3 * 80);
        ByteBufUtil$HexUtil.appendPrettyHexDump(stringBuilder, byteBuf, n, n2);
        return stringBuilder.toString();
    }

    private static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (MathUtil.isOutOfBounds(n, n2, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= offset(" + n + ") <= offset + length(" + n2 + ") <= buf.capacity(" + byteBuf.capacity() + ')');
        }
        if (n2 == 0) {
            return;
        }
        stringBuilder.append("         +-------------------------------------------------+" + StringUtil.NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
        int n6 = n2 >>> 4;
        int n7 = n2 & 0xF;
        for (n5 = 0; n5 < n6; ++n5) {
            int n8;
            n4 = (n5 << 4) + n;
            ByteBufUtil$HexUtil.appendHexDumpRowPrefix(stringBuilder, n5, n4);
            n3 = n4 + 16;
            for (n8 = n4; n8 < n3; ++n8) {
                stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n8)]);
            }
            stringBuilder.append(" |");
            for (n8 = n4; n8 < n3; ++n8) {
                stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n8)]);
            }
            stringBuilder.append('|');
        }
        if (n7 != 0) {
            n5 = (n6 << 4) + n;
            ByteBufUtil$HexUtil.appendHexDumpRowPrefix(stringBuilder, n6, n5);
            n4 = n5 + n7;
            for (n3 = n5; n3 < n4; ++n3) {
                stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n3)]);
            }
            stringBuilder.append(HEXPADDING[n7]);
            stringBuilder.append(" |");
            for (n3 = n5; n3 < n4; ++n3) {
                stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n3)]);
            }
            stringBuilder.append(BYTEPADDING[n7]);
            stringBuilder.append('|');
        }
        stringBuilder.append(StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
    }

    private static void appendHexDumpRowPrefix(StringBuilder stringBuilder, int n, int n2) {
        if (n < HEXDUMP_ROWPREFIXES.length) {
            stringBuilder.append(HEXDUMP_ROWPREFIXES[n]);
        } else {
            stringBuilder.append(StringUtil.NEWLINE);
            stringBuilder.append(Long.toHexString((long)n2 & 0xFFFFFFFFL | 0x100000000L));
            stringBuilder.setCharAt(stringBuilder.length() - 9, '|');
            stringBuilder.append('|');
        }
    }

    static /* synthetic */ String access$000(ByteBuf byteBuf, int n, int n2) {
        return ByteBufUtil$HexUtil.hexDump(byteBuf, n, n2);
    }

    static /* synthetic */ String access$100(byte[] byArray, int n, int n2) {
        return ByteBufUtil$HexUtil.hexDump(byArray, n, n2);
    }

    static /* synthetic */ String access$400(ByteBuf byteBuf, int n, int n2) {
        return ByteBufUtil$HexUtil.prettyHexDump(byteBuf, n, n2);
    }

    static /* synthetic */ void access$500(StringBuilder stringBuilder, ByteBuf byteBuf, int n, int n2) {
        ByteBufUtil$HexUtil.appendPrettyHexDump(stringBuilder, byteBuf, n, n2);
    }

    static {
        int n;
        StringBuilder stringBuilder;
        int n2;
        BYTE2CHAR = new char[256];
        HEXDUMP_TABLE = new char[1024];
        HEXPADDING = new String[16];
        HEXDUMP_ROWPREFIXES = new String[4096];
        BYTE2HEX = new String[256];
        BYTEPADDING = new String[16];
        char[] cArray = "0123456789abcdef".toCharArray();
        for (n2 = 0; n2 < 256; ++n2) {
            ByteBufUtil$HexUtil.HEXDUMP_TABLE[n2 << 1] = cArray[n2 >>> 4 & 0xF];
            ByteBufUtil$HexUtil.HEXDUMP_TABLE[(n2 << 1) + 1] = cArray[n2 & 0xF];
        }
        for (n2 = 0; n2 < HEXPADDING.length; ++n2) {
            int n3 = HEXPADDING.length - n2;
            stringBuilder = new StringBuilder(n3 * 3);
            for (n = 0; n < n3; ++n) {
                stringBuilder.append("   ");
            }
            ByteBufUtil$HexUtil.HEXPADDING[n2] = stringBuilder.toString();
        }
        for (n2 = 0; n2 < HEXDUMP_ROWPREFIXES.length; ++n2) {
            StringBuilder stringBuilder2 = new StringBuilder(12);
            stringBuilder2.append(StringUtil.NEWLINE);
            stringBuilder2.append(Long.toHexString((long)(n2 << 4) & 0xFFFFFFFFL | 0x100000000L));
            stringBuilder2.setCharAt(stringBuilder2.length() - 9, '|');
            stringBuilder2.append('|');
            ByteBufUtil$HexUtil.HEXDUMP_ROWPREFIXES[n2] = stringBuilder2.toString();
        }
        for (n2 = 0; n2 < BYTE2HEX.length; ++n2) {
            ByteBufUtil$HexUtil.BYTE2HEX[n2] = ' ' + StringUtil.byteToHexStringPadded(n2);
        }
        for (n2 = 0; n2 < BYTEPADDING.length; ++n2) {
            int n4 = BYTEPADDING.length - n2;
            stringBuilder = new StringBuilder(n4);
            for (n = 0; n < n4; ++n) {
                stringBuilder.append(' ');
            }
            ByteBufUtil$HexUtil.BYTEPADDING[n2] = stringBuilder.toString();
        }
        for (n2 = 0; n2 < BYTE2CHAR.length; ++n2) {
            ByteBufUtil$HexUtil.BYTE2CHAR[n2] = n2 <= 31 || n2 >= 127 ? 46 : (char)n2;
        }
    }
}

