/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$1;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$WriteTask$1;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.util.internal.ObjectPool;
import pro.gravit.repackage.io.netty.util.internal.ObjectPool$Handle;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;

final class AbstractChannelHandlerContext$WriteTask
implements Runnable {
    private static final ObjectPool<AbstractChannelHandlerContext$WriteTask> RECYCLER = ObjectPool.newPool(new AbstractChannelHandlerContext$WriteTask$1());
    private static final boolean ESTIMATE_TASK_SIZE_ON_SUBMIT = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.transport.estimateSizeOnSubmit", true);
    private static final int WRITE_TASK_OVERHEAD = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.transport.writeTaskSizeOverhead", 32);
    private final ObjectPool$Handle<AbstractChannelHandlerContext$WriteTask> handle;
    private AbstractChannelHandlerContext ctx;
    private Object msg;
    private ChannelPromise promise;
    private int size;

    static AbstractChannelHandlerContext$WriteTask newInstance(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl) {
        AbstractChannelHandlerContext$WriteTask abstractChannelHandlerContext$WriteTask = RECYCLER.get();
        AbstractChannelHandlerContext$WriteTask.init(abstractChannelHandlerContext$WriteTask, abstractChannelHandlerContext, object, channelPromise, bl);
        return abstractChannelHandlerContext$WriteTask;
    }

    private AbstractChannelHandlerContext$WriteTask(ObjectPool$Handle<? extends AbstractChannelHandlerContext$WriteTask> objectPool$Handle) {
        this.handle = objectPool$Handle;
    }

    protected static void init(AbstractChannelHandlerContext$WriteTask abstractChannelHandlerContext$WriteTask, AbstractChannelHandlerContext abstractChannelHandlerContext, Object object, ChannelPromise channelPromise, boolean bl) {
        abstractChannelHandlerContext$WriteTask.ctx = abstractChannelHandlerContext;
        abstractChannelHandlerContext$WriteTask.msg = object;
        abstractChannelHandlerContext$WriteTask.promise = channelPromise;
        if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
            abstractChannelHandlerContext$WriteTask.size = AbstractChannelHandlerContext.access$1700(abstractChannelHandlerContext).estimatorHandle().size(object) + WRITE_TASK_OVERHEAD;
            AbstractChannelHandlerContext.access$1700(abstractChannelHandlerContext).incrementPendingOutboundBytes(abstractChannelHandlerContext$WriteTask.size);
        } else {
            abstractChannelHandlerContext$WriteTask.size = 0;
        }
        if (bl) {
            abstractChannelHandlerContext$WriteTask.size |= Integer.MIN_VALUE;
        }
    }

    @Override
    public void run() {
        try {
            this.decrementPendingOutboundBytes();
            if (this.size >= 0) {
                this.ctx.invokeWrite(this.msg, this.promise);
            } else {
                this.ctx.invokeWriteAndFlush(this.msg, this.promise);
            }
        }
        finally {
            this.recycle();
        }
    }

    void cancel() {
        try {
            this.decrementPendingOutboundBytes();
        }
        finally {
            this.recycle();
        }
    }

    private void decrementPendingOutboundBytes() {
        if (ESTIMATE_TASK_SIZE_ON_SUBMIT) {
            AbstractChannelHandlerContext.access$1700(this.ctx).decrementPendingOutboundBytes(this.size & Integer.MAX_VALUE);
        }
    }

    private void recycle() {
        this.ctx = null;
        this.msg = null;
        this.promise = null;
        this.handle.recycle(this);
    }

    /* synthetic */ AbstractChannelHandlerContext$WriteTask(ObjectPool$Handle objectPool$Handle, AbstractChannelHandlerContext$1 abstractChannelHandlerContext$1) {
        this(objectPool$Handle);
    }
}

