/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.local;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.AbstractChannel;
import pro.gravit.repackage.io.netty.channel.AbstractChannel$AbstractUnsafe;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelMetadata;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.DefaultChannelConfig;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.PreferHeapByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.RecvByteBufAllocator$Handle;
import pro.gravit.repackage.io.netty.channel.SingleThreadEventLoop;
import pro.gravit.repackage.io.netty.channel.local.LocalAddress;
import pro.gravit.repackage.io.netty.channel.local.LocalChannel$1;
import pro.gravit.repackage.io.netty.channel.local.LocalChannel$2;
import pro.gravit.repackage.io.netty.channel.local.LocalChannel$3;
import pro.gravit.repackage.io.netty.channel.local.LocalChannel$4;
import pro.gravit.repackage.io.netty.channel.local.LocalChannel$5;
import pro.gravit.repackage.io.netty.channel.local.LocalChannel$LocalUnsafe;
import pro.gravit.repackage.io.netty.channel.local.LocalChannel$State;
import pro.gravit.repackage.io.netty.channel.local.LocalChannelRegistry;
import pro.gravit.repackage.io.netty.channel.local.LocalServerChannel;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.SingleThreadEventExecutor;
import pro.gravit.repackage.io.netty.util.internal.InternalThreadLocalMap;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class LocalChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LocalChannel.class);
    private static final AtomicReferenceFieldUpdater<LocalChannel, Future> FINISH_READ_FUTURE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LocalChannel.class, Future.class, "finishReadFuture");
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final int MAX_READER_STACK_DEPTH = 8;
    private final ChannelConfig config = new DefaultChannelConfig(this);
    final Queue<Object> inboundBuffer = PlatformDependent.newSpscQueue();
    private final Runnable readTask = new LocalChannel$1(this);
    private final Runnable shutdownHook = new LocalChannel$2(this);
    private volatile LocalChannel$State state;
    private volatile LocalChannel peer;
    private volatile LocalAddress localAddress;
    private volatile LocalAddress remoteAddress;
    private volatile ChannelPromise connectPromise;
    private volatile boolean readInProgress;
    private volatile boolean writeInProgress;
    private volatile Future<?> finishReadFuture;

    public LocalChannel() {
        super(null);
        this.config().setAllocator(new PreferHeapByteBufAllocator(this.config.getAllocator()));
    }

    protected LocalChannel(LocalServerChannel localServerChannel, LocalChannel localChannel) {
        super(localServerChannel);
        this.config().setAllocator(new PreferHeapByteBufAllocator(this.config.getAllocator()));
        this.peer = localChannel;
        this.localAddress = localServerChannel.localAddress();
        this.remoteAddress = localChannel.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public LocalServerChannel parent() {
        return (LocalServerChannel)super.parent();
    }

    @Override
    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    @Override
    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.state != LocalChannel$State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == LocalChannel$State.CONNECTED;
    }

    @Override
    protected AbstractChannel$AbstractUnsafe newUnsafe() {
        return new LocalChannel$LocalUnsafe(this, null);
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof SingleThreadEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    @Override
    protected void doRegister() {
        if (this.peer != null && this.parent() != null) {
            LocalChannel localChannel = this.peer;
            this.state = LocalChannel$State.CONNECTED;
            localChannel.remoteAddress = this.parent() == null ? null : this.parent().localAddress();
            localChannel.state = LocalChannel$State.CONNECTED;
            localChannel.eventLoop().execute(new LocalChannel$3(this, localChannel));
        }
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).addShutdownHook(this.shutdownHook);
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, socketAddress);
        this.state = LocalChannel$State.BOUND;
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        LocalChannel localChannel = this.peer;
        LocalChannel$State localChannel$State = this.state;
        try {
            Object object;
            if (localChannel$State != LocalChannel$State.CLOSED) {
                if (this.localAddress != null) {
                    if (this.parent() == null) {
                        LocalChannelRegistry.unregister(this.localAddress);
                    }
                    this.localAddress = null;
                }
                this.state = LocalChannel$State.CLOSED;
                if (this.writeInProgress && localChannel != null) {
                    this.finishPeerRead(localChannel);
                }
                if ((object = this.connectPromise) != null) {
                    object.tryFailure(new ClosedChannelException());
                    this.connectPromise = null;
                }
            }
            if (localChannel != null) {
                this.peer = null;
                object = localChannel.eventLoop();
                boolean bl = localChannel.isActive();
                try {
                    object.execute(new LocalChannel$4(this, localChannel, bl));
                }
                catch (Throwable throwable) {
                    logger.warn("Releasing Inbound Queues for channels {}-{} because exception occurred!", this, localChannel, throwable);
                    if (object.inEventLoop()) {
                        localChannel.releaseInboundBuffers();
                    } else {
                        localChannel.close();
                    }
                    PlatformDependent.throwException(throwable);
                }
            }
        }
        finally {
            if (localChannel$State != null && localChannel$State != LocalChannel$State.CLOSED) {
                this.releaseInboundBuffers();
            }
        }
    }

    private void tryClose(boolean bl) {
        if (bl) {
            this.unsafe().close(this.unsafe().voidPromise());
        } else {
            this.releaseInboundBuffers();
        }
    }

    @Override
    protected void doDeregister() {
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).removeShutdownHook(this.shutdownHook);
    }

    private void readInbound() {
        Object object;
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.unsafe().recvBufAllocHandle();
        recvByteBufAllocator$Handle.reset(this.config());
        ChannelPipeline channelPipeline = this.pipeline();
        while ((object = this.inboundBuffer.poll()) != null) {
            if (object instanceof ByteBuf && this.inboundBuffer.peek() instanceof ByteBuf) {
                ByteBuf byteBuf = (ByteBuf)object;
                ByteBuf byteBuf2 = recvByteBufAllocator$Handle.allocate(this.alloc());
                if (byteBuf.readableBytes() < byteBuf2.writableBytes()) {
                    byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                    byteBuf.release();
                    while ((object = this.inboundBuffer.peek()) instanceof ByteBuf && ((ByteBuf)object).readableBytes() < byteBuf2.writableBytes()) {
                        this.inboundBuffer.poll();
                        byteBuf = (ByteBuf)object;
                        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                        byteBuf.release();
                    }
                    recvByteBufAllocator$Handle.lastBytesRead(byteBuf2.readableBytes());
                    object = byteBuf2;
                } else {
                    recvByteBufAllocator$Handle.lastBytesRead(byteBuf2.capacity());
                    byteBuf2.release();
                }
            }
            recvByteBufAllocator$Handle.incMessagesRead(1);
            channelPipeline.fireChannelRead(object);
            if (recvByteBufAllocator$Handle.continueReading()) continue;
        }
        recvByteBufAllocator$Handle.readComplete();
        channelPipeline.fireChannelReadComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBeginRead() {
        if (this.readInProgress) {
            return;
        }
        Queue<Object> queue = this.inboundBuffer;
        if (queue.isEmpty()) {
            this.readInProgress = true;
            return;
        }
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        int n = internalThreadLocalMap.localChannelReaderStackDepth();
        if (n < 8) {
            internalThreadLocalMap.setLocalChannelReaderStackDepth(n + 1);
            try {
                this.readInbound();
            }
            finally {
                internalThreadLocalMap.setLocalChannelReaderStackDepth(n);
            }
        }
        try {
            this.eventLoop().execute(this.readTask);
        }
        catch (Throwable throwable) {
            logger.warn("Closing Local channels {}-{} because exception occurred!", this, this.peer, throwable);
            this.close();
            this.peer.close();
            PlatformDependent.throwException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        switch (this.state) {
            case OPEN: 
            case BOUND: {
                throw new NotYetConnectedException();
            }
            case CLOSED: {
                throw new ClosedChannelException();
            }
        }
        LocalChannel localChannel = this.peer;
        this.writeInProgress = true;
        try {
            Object object;
            ClosedChannelException closedChannelException = null;
            while ((object = channelOutboundBuffer.current()) != null) {
                try {
                    if (localChannel.state == LocalChannel$State.CONNECTED) {
                        localChannel.inboundBuffer.add(ReferenceCountUtil.retain(object));
                        channelOutboundBuffer.remove();
                        continue;
                    }
                    if (closedChannelException == null) {
                        closedChannelException = new ClosedChannelException();
                    }
                    channelOutboundBuffer.remove(closedChannelException);
                }
                catch (Throwable throwable) {
                    channelOutboundBuffer.remove(throwable);
                }
            }
        }
        finally {
            this.writeInProgress = false;
        }
        this.finishPeerRead(localChannel);
    }

    private void finishPeerRead(LocalChannel localChannel) {
        if (localChannel.eventLoop() == this.eventLoop() && !localChannel.writeInProgress) {
            this.finishPeerRead0(localChannel);
        } else {
            this.runFinishPeerReadTask(localChannel);
        }
    }

    private void runFinishPeerReadTask(LocalChannel localChannel) {
        LocalChannel$5 localChannel$5 = new LocalChannel$5(this, localChannel);
        try {
            if (localChannel.writeInProgress) {
                localChannel.finishReadFuture = localChannel.eventLoop().submit(localChannel$5);
            } else {
                localChannel.eventLoop().execute(localChannel$5);
            }
        }
        catch (Throwable throwable) {
            logger.warn("Closing Local channels {}-{} because exception occurred!", this, localChannel, throwable);
            this.close();
            localChannel.close();
            PlatformDependent.throwException(throwable);
        }
    }

    private void releaseInboundBuffers() {
        Object object;
        assert (this.eventLoop() == null || this.eventLoop().inEventLoop());
        this.readInProgress = false;
        Queue<Object> queue = this.inboundBuffer;
        while ((object = queue.poll()) != null) {
            ReferenceCountUtil.release(object);
        }
    }

    private void finishPeerRead0(LocalChannel localChannel) {
        Future<?> future = localChannel.finishReadFuture;
        if (future != null) {
            if (!future.isDone()) {
                this.runFinishPeerReadTask(localChannel);
                return;
            }
            FINISH_READ_FUTURE_UPDATER.compareAndSet(localChannel, future, null);
        }
        if (localChannel.readInProgress && !localChannel.inboundBuffer.isEmpty()) {
            localChannel.readInProgress = false;
            localChannel.readInbound();
        }
    }

    static /* synthetic */ void access$000(LocalChannel localChannel) {
        localChannel.readInbound();
    }

    static /* synthetic */ ChannelPromise access$200(LocalChannel localChannel) {
        return localChannel.connectPromise;
    }

    static /* synthetic */ void access$300(LocalChannel localChannel, boolean bl) {
        localChannel.tryClose(bl);
    }

    static /* synthetic */ void access$400(LocalChannel localChannel, LocalChannel localChannel2) {
        localChannel.finishPeerRead0(localChannel2);
    }

    static /* synthetic */ LocalChannel$State access$500(LocalChannel localChannel) {
        return localChannel.state;
    }

    static /* synthetic */ ChannelPromise access$202(LocalChannel localChannel, ChannelPromise channelPromise) {
        localChannel.connectPromise = channelPromise;
        return localChannel.connectPromise;
    }

    static /* synthetic */ LocalChannel access$602(LocalChannel localChannel, LocalChannel localChannel2) {
        localChannel.peer = localChannel2;
        return localChannel.peer;
    }
}

