/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.nio;

import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.List;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.RecvByteBufAllocator$Handle;
import pro.gravit.repackage.io.netty.channel.ServerChannel;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioMessageChannel$NioMessageUnsafe;

public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    boolean inputShutdown;

    protected AbstractNioMessageChannel(Channel channel, SelectableChannel selectableChannel, int n) {
        super(channel, selectableChannel, n);
    }

    @Override
    protected AbstractNioChannel$AbstractNioUnsafe newUnsafe() {
        return new AbstractNioMessageChannel$NioMessageUnsafe(this);
    }

    @Override
    protected void doBeginRead() {
        if (this.inputShutdown) {
            return;
        }
        super.doBeginRead();
    }

    protected boolean continueReading(RecvByteBufAllocator$Handle recvByteBufAllocator$Handle) {
        return recvByteBufAllocator$Handle.continueReading();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        SelectionKey selectionKey = this.selectionKey();
        int n = selectionKey.interestOps();
        int n2 = this.maxMessagesPerWrite();
        while (n2 > 0 && (object = channelOutboundBuffer.current()) != null) {
            try {
                boolean bl = false;
                for (int i = this.config().getWriteSpinCount() - 1; i >= 0; --i) {
                    if (!this.doWriteMessage(object, channelOutboundBuffer)) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
                --n2;
                channelOutboundBuffer.remove();
            }
            catch (Exception exception) {
                if (this.continueOnWriteError()) {
                    --n2;
                    channelOutboundBuffer.remove(exception);
                    continue;
                }
                throw exception;
            }
        }
        if (channelOutboundBuffer.isEmpty()) {
            if ((n & 4) != 0) {
                selectionKey.interestOps(n & 0xFFFFFFFB);
            }
        } else if ((n & 4) == 0) {
            selectionKey.interestOps(n | 4);
        }
    }

    protected boolean continueOnWriteError() {
        return false;
    }

    protected boolean closeOnReadError(Throwable throwable) {
        if (!this.isActive()) {
            return true;
        }
        if (throwable instanceof PortUnreachableException) {
            return false;
        }
        if (throwable instanceof IOException) {
            return !(this instanceof ServerChannel);
        }
        return true;
    }

    protected abstract int doReadMessages(List<Object> var1);

    protected abstract boolean doWriteMessage(Object var1, ChannelOutboundBuffer var2);
}

