/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.pool;

import java.util.Deque;
import java.util.concurrent.Callable;
import pro.gravit.repackage.io.netty.bootstrap.Bootstrap;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.pool.ChannelHealthChecker;
import pro.gravit.repackage.io.netty.channel.pool.ChannelPool;
import pro.gravit.repackage.io.netty.channel.pool.ChannelPoolHandler;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool$1;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool$2;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool$3;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool$4;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool$5;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool$6;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool$7;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool$ChannelPoolFullException;
import pro.gravit.repackage.io.netty.util.AttributeKey;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GlobalEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

public class SimpleChannelPool
implements ChannelPool {
    private static final AttributeKey<SimpleChannelPool> POOL_KEY = AttributeKey.newInstance("pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool");
    private final Deque<Channel> deque = PlatformDependent.newConcurrentDeque();
    private final ChannelPoolHandler handler;
    private final ChannelHealthChecker healthCheck;
    private final Bootstrap bootstrap;
    private final boolean releaseHealthCheck;
    private final boolean lastRecentUsed;

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler) {
        this(bootstrap, channelPoolHandler, ChannelHealthChecker.ACTIVE);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, boolean bl) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, bl, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, boolean bl, boolean bl2) {
        this.handler = ObjectUtil.checkNotNull(channelPoolHandler, "handler");
        this.healthCheck = ObjectUtil.checkNotNull(channelHealthChecker, "healthCheck");
        this.releaseHealthCheck = bl;
        this.bootstrap = ObjectUtil.checkNotNull(bootstrap, "bootstrap").clone();
        this.bootstrap.handler(new SimpleChannelPool$1(this, channelPoolHandler));
        this.lastRecentUsed = bl2;
    }

    protected Bootstrap bootstrap() {
        return this.bootstrap;
    }

    protected ChannelPoolHandler handler() {
        return this.handler;
    }

    protected ChannelHealthChecker healthChecker() {
        return this.healthCheck;
    }

    protected boolean releaseHealthCheck() {
        return this.releaseHealthCheck;
    }

    @Override
    public final Future<Channel> acquire() {
        return this.acquire(this.bootstrap.config().group().next().newPromise());
    }

    @Override
    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.acquireHealthyFromPoolOrNew(ObjectUtil.checkNotNull(promise, "promise"));
    }

    private Future<Channel> acquireHealthyFromPoolOrNew(Promise<Channel> promise) {
        try {
            Channel channel = this.pollChannel();
            if (channel == null) {
                Bootstrap bootstrap = this.bootstrap.clone();
                bootstrap.attr(POOL_KEY, this);
                ChannelFuture channelFuture = this.connectChannel(bootstrap);
                if (channelFuture.isDone()) {
                    this.notifyConnect(channelFuture, promise);
                } else {
                    channelFuture.addListener(new SimpleChannelPool$2(this, promise));
                }
            } else {
                EventLoop eventLoop = channel.eventLoop();
                if (eventLoop.inEventLoop()) {
                    this.doHealthCheck(channel, promise);
                } else {
                    eventLoop.execute(new SimpleChannelPool$3(this, channel, promise));
                }
            }
        }
        catch (Throwable throwable) {
            promise.tryFailure(throwable);
        }
        return promise;
    }

    private void notifyConnect(ChannelFuture channelFuture, Promise<Channel> promise) {
        Channel channel = null;
        try {
            if (channelFuture.isSuccess()) {
                channel = channelFuture.channel();
                this.handler.channelAcquired(channel);
                if (!promise.trySuccess(channel)) {
                    this.release(channel);
                }
            } else {
                promise.tryFailure(channelFuture.cause());
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    private void doHealthCheck(Channel channel, Promise<Channel> promise) {
        try {
            assert (channel.eventLoop().inEventLoop());
            Future<Boolean> future = this.healthCheck.isHealthy(channel);
            if (future.isDone()) {
                this.notifyHealthCheck(future, channel, promise);
            } else {
                future.addListener(new SimpleChannelPool$4(this, channel, promise));
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    private void notifyHealthCheck(Future<Boolean> future, Channel channel, Promise<Channel> promise) {
        try {
            assert (channel.eventLoop().inEventLoop());
            if (future.isSuccess() && future.getNow().booleanValue()) {
                channel.attr(POOL_KEY).set(this);
                this.handler.channelAcquired(channel);
                promise.setSuccess(channel);
            } else {
                this.closeChannel(channel);
                this.acquireHealthyFromPoolOrNew(promise);
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    protected ChannelFuture connectChannel(Bootstrap bootstrap) {
        return bootstrap.connect();
    }

    @Override
    public final Future<Void> release(Channel channel) {
        return this.release(channel, channel.eventLoop().newPromise());
    }

    @Override
    public Future<Void> release(Channel channel, Promise<Void> promise) {
        try {
            ObjectUtil.checkNotNull(channel, "channel");
            ObjectUtil.checkNotNull(promise, "promise");
            EventLoop eventLoop = channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.doReleaseChannel(channel, promise);
            } else {
                eventLoop.execute(new SimpleChannelPool$5(this, channel, promise));
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
        return promise;
    }

    private void doReleaseChannel(Channel channel, Promise<Void> promise) {
        try {
            assert (channel.eventLoop().inEventLoop());
            if (channel.attr(POOL_KEY).getAndSet(null) != this) {
                this.closeAndFail(channel, new IllegalArgumentException("Channel " + channel + " was not acquired from this ChannelPool"), promise);
            } else if (this.releaseHealthCheck) {
                this.doHealthCheckOnRelease(channel, promise);
            } else {
                this.releaseAndOffer(channel, promise);
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    private void doHealthCheckOnRelease(Channel channel, Promise<Void> promise) {
        Future<Boolean> future = this.healthCheck.isHealthy(channel);
        if (future.isDone()) {
            this.releaseAndOfferIfHealthy(channel, promise, future);
        } else {
            future.addListener(new SimpleChannelPool$6(this, channel, promise, future));
        }
    }

    private void releaseAndOfferIfHealthy(Channel channel, Promise<Void> promise, Future<Boolean> future) {
        try {
            if (future.getNow().booleanValue()) {
                this.releaseAndOffer(channel, promise);
            } else {
                this.handler.channelReleased(channel);
                promise.setSuccess(null);
            }
        }
        catch (Throwable throwable) {
            this.closeAndFail(channel, throwable, promise);
        }
    }

    private void releaseAndOffer(Channel channel, Promise<Void> promise) {
        if (this.offerChannel(channel)) {
            this.handler.channelReleased(channel);
            promise.setSuccess(null);
        } else {
            this.closeAndFail(channel, new SimpleChannelPool$ChannelPoolFullException(), promise);
        }
    }

    private void closeChannel(Channel channel) {
        channel.attr(POOL_KEY).getAndSet(null);
        channel.close();
    }

    private void closeAndFail(Channel channel, Throwable throwable, Promise<?> promise) {
        if (channel != null) {
            try {
                this.closeChannel(channel);
            }
            catch (Throwable throwable2) {
                promise.tryFailure(throwable2);
            }
        }
        promise.tryFailure(throwable);
    }

    protected Channel pollChannel() {
        return this.lastRecentUsed ? this.deque.pollLast() : this.deque.pollFirst();
    }

    protected boolean offerChannel(Channel channel) {
        return this.deque.offer(channel);
    }

    @Override
    public void close() {
        Channel channel;
        while ((channel = this.pollChannel()) != null) {
            channel.close().awaitUninterruptibly();
        }
    }

    public Future<Void> closeAsync() {
        return GlobalEventExecutor.INSTANCE.submit((Callable)new SimpleChannelPool$7(this));
    }

    static /* synthetic */ void access$000(SimpleChannelPool simpleChannelPool, ChannelFuture channelFuture, Promise promise) {
        simpleChannelPool.notifyConnect(channelFuture, promise);
    }

    static /* synthetic */ void access$100(SimpleChannelPool simpleChannelPool, Channel channel, Promise promise) {
        simpleChannelPool.doHealthCheck(channel, promise);
    }

    static /* synthetic */ void access$200(SimpleChannelPool simpleChannelPool, Future future, Channel channel, Promise promise) {
        simpleChannelPool.notifyHealthCheck(future, channel, promise);
    }

    static /* synthetic */ void access$300(SimpleChannelPool simpleChannelPool, Channel channel, Promise promise) {
        simpleChannelPool.doReleaseChannel(channel, promise);
    }

    static /* synthetic */ void access$400(SimpleChannelPool simpleChannelPool, Channel channel, Promise promise, Future future) {
        simpleChannelPool.releaseAndOfferIfHealthy(channel, promise, future);
    }
}

