/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.socket.nio;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import pro.gravit.repackage.io.netty.channel.socket.InternetProtocolFamily;
import pro.gravit.repackage.io.netty.channel.socket.nio.ProtocolFamilyConverter;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

final class SelectorProviderUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelectorProviderUtil.class);

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static Method findOpenMethod(String string) {
        if (PlatformDependent.javaVersion() >= 15) {
            try {
                return SelectorProvider.class.getMethod(string, ProtocolFamily.class);
            }
            catch (Throwable throwable) {
                logger.debug("SelectorProvider.{}(ProtocolFamily) not available, will use default", (Object)string, (Object)throwable);
            }
        }
        return null;
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static <C extends Channel> C newChannel(Method method, SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        if (internetProtocolFamily != null && method != null) {
            try {
                Channel channel = (Channel)method.invoke((Object)selectorProvider, ProtocolFamilyConverter.convert(internetProtocolFamily));
                return (C)channel;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException);
            }
        }
        return null;
    }

    private SelectorProviderUtil() {
    }
}

