/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpConstants;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.AbstractHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.DeleteFileOnExitHook;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpData;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class AbstractDiskHttpData
extends AbstractHttpData {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractDiskHttpData.class);
    private File file;
    private boolean isRenamed;
    private FileChannel fileChannel;

    protected AbstractDiskHttpData(String string, Charset charset, long l) {
        super(string, charset, l);
    }

    protected abstract String getDiskFilename();

    protected abstract String getPrefix();

    protected abstract String getBaseDirectory();

    protected abstract String getPostfix();

    protected abstract boolean deleteOnExit();

    private File tempFile() {
        String string = this.getDiskFilename();
        String string2 = string != null ? '_' + Integer.toString(string.hashCode()) : this.getPostfix();
        File file = this.getBaseDirectory() == null ? PlatformDependent.createTempFile(this.getPrefix(), string2, null) : PlatformDependent.createTempFile(this.getPrefix(), string2, new File(this.getBaseDirectory()));
        if (this.deleteOnExit()) {
            DeleteFileOnExitHook.add(file.getPath());
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(ByteBuf byteBuf) {
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        try {
            this.size = byteBuf.readableBytes();
            this.checkSize(this.size);
            if (this.definedSize > 0L && this.definedSize < this.size) {
                throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
            }
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (byteBuf.readableBytes() == 0) {
                if (!this.file.createNewFile()) {
                    if (this.file.length() == 0L) {
                        return;
                    }
                    if (!this.file.delete() || !this.file.createNewFile()) {
                        throw new IOException("file exists already: " + this.file);
                    }
                }
                return;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
            try {
                randomAccessFile.setLength(0L);
                FileChannel fileChannel = randomAccessFile.getChannel();
                ByteBuffer byteBuffer = byteBuf.nioBuffer();
                int n = 0;
                while ((long)n < this.size) {
                    n += fileChannel.write(byteBuffer);
                }
                byteBuf.readerIndex(byteBuf.readerIndex() + n);
                fileChannel.force(false);
            }
            finally {
                randomAccessFile.close();
            }
            this.setCompleted();
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContent(ByteBuf byteBuf, boolean bl) {
        if (byteBuf != null) {
            try {
                int n;
                int n2 = byteBuf.readableBytes();
                this.checkSize(this.size + (long)n2);
                if (this.definedSize > 0L && this.definedSize < this.size + (long)n2) {
                    throw new IOException("Out of size: " + (this.size + (long)n2) + " > " + this.definedSize);
                }
                if (this.file == null) {
                    this.file = this.tempFile();
                }
                if (this.fileChannel == null) {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
                    this.fileChannel = randomAccessFile.getChannel();
                }
                int n3 = n2;
                long l = this.fileChannel.position();
                int n4 = byteBuf.readerIndex();
                while (n3 > 0 && (n = byteBuf.getBytes(n4, this.fileChannel, l, n3)) >= 0) {
                    n3 -= n;
                    l += (long)n;
                    n4 += n;
                }
                this.fileChannel.position(l);
                byteBuf.readerIndex(n4);
                this.size += (long)(n2 - n3);
            }
            finally {
                byteBuf.release();
            }
        }
        if (bl) {
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (this.fileChannel == null) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
                this.fileChannel = randomAccessFile.getChannel();
            }
            try {
                this.fileChannel.force(false);
            }
            finally {
                this.fileChannel.close();
            }
            this.fileChannel = null;
            this.setCompleted();
        } else {
            ObjectUtil.checkNotNull(byteBuf, "buffer");
        }
    }

    @Override
    public void setContent(File file) {
        long l = file.length();
        this.checkSize(l);
        this.size = l;
        if (this.file != null) {
            this.delete();
        }
        this.file = file;
        this.isRenamed = true;
        this.setCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(InputStream inputStream) {
        ObjectUtil.checkNotNull(inputStream, "inputStream");
        if (this.file != null) {
            this.delete();
        }
        this.file = this.tempFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
        int n = 0;
        try {
            randomAccessFile.setLength(0L);
            FileChannel fileChannel = randomAccessFile.getChannel();
            byte[] byArray = new byte[16384];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                byteBuffer.position(n2).flip();
                this.checkSize(n += fileChannel.write(byteBuffer));
                byteBuffer.clear();
                n2 = inputStream.read(byArray);
            }
            fileChannel.force(false);
        }
        finally {
            randomAccessFile.close();
        }
        this.size = n;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            if (!this.file.delete()) {
                logger.warn("Failed to delete: {}", (Object)this.file);
            }
            this.file = null;
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        this.isRenamed = true;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.force(false);
            }
            catch (IOException iOException) {
                logger.warn("Failed to force.", iOException);
            }
            finally {
                try {
                    this.fileChannel.close();
                }
                catch (IOException iOException) {
                    logger.warn("Failed to close a file.", iOException);
                }
            }
            this.fileChannel = null;
        }
        if (!this.isRenamed) {
            String string = null;
            if (this.file != null && this.file.exists()) {
                string = this.file.getPath();
                if (!this.file.delete()) {
                    string = null;
                    logger.warn("Failed to delete: {}", (Object)this.file);
                }
            }
            if (this.deleteOnExit() && string != null) {
                DeleteFileOnExitHook.remove(string);
            }
            this.file = null;
        }
    }

    @Override
    public byte[] get() {
        if (this.file == null) {
            return EmptyArrays.EMPTY_BYTES;
        }
        return AbstractDiskHttpData.readFrom(this.file);
    }

    @Override
    public ByteBuf getByteBuf() {
        if (this.file == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        byte[] byArray = AbstractDiskHttpData.readFrom(this.file);
        return Unpooled.wrappedBuffer(byArray);
    }

    @Override
    public ByteBuf getChunk(int n) {
        int n2;
        if (this.file == null || n == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (this.fileChannel == null) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
            this.fileChannel = randomAccessFile.getChannel();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        try {
            int n3;
            for (n2 = 0; n2 < n; n2 += n3) {
                n3 = this.fileChannel.read(byteBuffer);
                if (n3 != -1) continue;
                this.fileChannel.close();
                this.fileChannel = null;
                break;
            }
        }
        catch (IOException iOException) {
            this.fileChannel.close();
            this.fileChannel = null;
            throw iOException;
        }
        if (n2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        byteBuffer.flip();
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byteBuffer);
        byteBuf.readerIndex(0);
        byteBuf.writerIndex(n2);
        return byteBuf;
    }

    @Override
    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset charset) {
        if (this.file == null) {
            return "";
        }
        if (charset == null) {
            byte[] byArray = AbstractDiskHttpData.readFrom(this.file);
            return new String(byArray, HttpConstants.DEFAULT_CHARSET.name());
        }
        byte[] byArray = AbstractDiskHttpData.readFrom(this.file);
        return new String(byArray, charset.name());
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameTo(File file) {
        ObjectUtil.checkNotNull(file, "dest");
        if (this.file == null) {
            throw new IOException("No file defined so cannot be renamed");
        }
        if (!this.file.renameTo(file)) {
            long l;
            IOException iOException = null;
            RandomAccessFile randomAccessFile = null;
            RandomAccessFile randomAccessFile2 = null;
            long l2 = 8196L;
            try {
                randomAccessFile = new RandomAccessFile(this.file, "r");
                randomAccessFile2 = new RandomAccessFile(file, "rw");
                FileChannel fileChannel = randomAccessFile.getChannel();
                FileChannel fileChannel2 = randomAccessFile2.getChannel();
                for (l = 0L; l < this.size; l += fileChannel.transferTo(l, l2, fileChannel2)) {
                    if (l2 >= this.size - l) continue;
                    l2 = this.size - l;
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException3) {
                        if (iOException == null) {
                            iOException = iOException3;
                        }
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", iOException3);
                    }
                }
                if (randomAccessFile2 != null) {
                    try {
                        randomAccessFile2.close();
                    }
                    catch (IOException iOException4) {
                        if (iOException == null) {
                            iOException = iOException4;
                        }
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", iOException4);
                    }
                }
            }
            if (iOException != null) {
                throw iOException;
            }
            if (l == this.size) {
                if (!this.file.delete()) {
                    logger.warn("Failed to delete: {}", (Object)this.file);
                }
                this.file = file;
                this.isRenamed = true;
                return true;
            }
            if (!file.delete()) {
                logger.warn("Failed to delete: {}", (Object)file);
            }
            return false;
        }
        this.file = file;
        this.isRenamed = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFrom(File file) {
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)l];
        try {
            FileChannel fileChannel = randomAccessFile.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n = 0;
            while ((long)n < l) {
                n += fileChannel.read(byteBuffer);
            }
        }
        finally {
            randomAccessFile.close();
        }
        return byArray;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public HttpData touch() {
        return this;
    }

    @Override
    public HttpData touch(Object object) {
        return this;
    }
}

