/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.marshalling;

import org.jboss.marshalling.ByteInput;
import pro.gravit.repackage.io.netty.handler.codec.marshalling.LimitingByteInput$TooBigObjectException;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

class LimitingByteInput
implements ByteInput {
    private static final LimitingByteInput$TooBigObjectException EXCEPTION = new LimitingByteInput$TooBigObjectException();
    private final ByteInput input;
    private final long limit;
    private long read;

    LimitingByteInput(ByteInput byteInput, long l) {
        this.input = byteInput;
        this.limit = ObjectUtil.checkPositive(l, "limit");
    }

    public void close() {
    }

    public int available() {
        return this.readable(this.input.available());
    }

    public int read() {
        int n = this.readable(1);
        if (n > 0) {
            int n2 = this.input.read();
            ++this.read;
            return n2;
        }
        throw EXCEPTION;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.readable(n2);
        if (n3 > 0) {
            int n4 = this.input.read(byArray, n, n3);
            this.read += (long)n4;
            return n4;
        }
        throw EXCEPTION;
    }

    public long skip(long l) {
        int n = this.readable((int)l);
        if (n > 0) {
            long l2 = this.input.skip((long)n);
            this.read += l2;
            return l2;
        }
        throw EXCEPTION;
    }

    private int readable(int n) {
        return (int)Math.min((long)n, this.limit - this.read);
    }
}

