/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.marshalling;

import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.MessageToByteEncoder;
import pro.gravit.repackage.io.netty.handler.codec.marshalling.ChannelBufferByteOutput;
import pro.gravit.repackage.io.netty.handler.codec.marshalling.MarshallerProvider;

@ChannelHandler.Sharable
public class MarshallingEncoder
extends MessageToByteEncoder<Object> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private final MarshallerProvider provider;

    public MarshallingEncoder(MarshallerProvider marshallerProvider) {
        this.provider = marshallerProvider;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) {
        Marshaller marshaller = this.provider.getMarshaller(channelHandlerContext);
        int n = byteBuf.writerIndex();
        byteBuf.writeBytes(LENGTH_PLACEHOLDER);
        ChannelBufferByteOutput channelBufferByteOutput = new ChannelBufferByteOutput(byteBuf);
        marshaller.start((ByteOutput)channelBufferByteOutput);
        marshaller.writeObject(object);
        marshaller.finish();
        marshaller.close();
        byteBuf.setInt(n, byteBuf.writerIndex() - n - 4);
    }
}

