/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ipfilter;

import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRule;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRuleType;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpSubnetFilterRule;

final class IpSubnetFilterRule$Ip6SubnetFilterRule
implements IpFilterRule {
    private static final BigInteger MINUS_ONE;
    private final BigInteger networkAddress;
    private final BigInteger subnetMask;
    private final IpFilterRuleType ruleType;
    static final /* synthetic */ boolean $assertionsDisabled;

    private IpSubnetFilterRule$Ip6SubnetFilterRule(Inet6Address inet6Address, int n, IpFilterRuleType ipFilterRuleType) {
        if (n < 0 || n > 128) {
            throw new IllegalArgumentException(String.format("IPv6 requires the subnet prefix to be in range of [0,128]. The prefix was: %d", n));
        }
        this.subnetMask = IpSubnetFilterRule$Ip6SubnetFilterRule.prefixToSubnetMask(n);
        this.networkAddress = IpSubnetFilterRule$Ip6SubnetFilterRule.ipToInt(inet6Address).and(this.subnetMask);
        this.ruleType = ipFilterRuleType;
    }

    @Override
    public boolean matches(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress instanceof Inet6Address) {
            BigInteger bigInteger = IpSubnetFilterRule$Ip6SubnetFilterRule.ipToInt((Inet6Address)inetAddress);
            return bigInteger.and(this.subnetMask).equals(this.subnetMask) || bigInteger.and(this.subnetMask).equals(this.networkAddress);
        }
        return false;
    }

    @Override
    public IpFilterRuleType ruleType() {
        return this.ruleType;
    }

    private static BigInteger ipToInt(Inet6Address inet6Address) {
        byte[] byArray = inet6Address.getAddress();
        if (!$assertionsDisabled && byArray.length != 16) {
            throw new AssertionError();
        }
        return new BigInteger(byArray);
    }

    private static BigInteger prefixToSubnetMask(int n) {
        return MINUS_ONE.shiftLeft(128 - n);
    }

    static /* synthetic */ BigInteger access$300(IpSubnetFilterRule$Ip6SubnetFilterRule ipSubnetFilterRule$Ip6SubnetFilterRule) {
        return ipSubnetFilterRule$Ip6SubnetFilterRule.networkAddress;
    }

    static /* synthetic */ BigInteger access$500(Inet6Address inet6Address) {
        return IpSubnetFilterRule$Ip6SubnetFilterRule.ipToInt(inet6Address);
    }

    static {
        $assertionsDisabled = !IpSubnetFilterRule.class.desiredAssertionStatus();
        MINUS_ONE = BigInteger.valueOf(-1L);
    }
}

