/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.util.LinkedHashSet;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$ProtocolSelectionListener;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$ProtocolSelector;
import pro.gravit.repackage.io.netty.handler.ssl.JdkSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.JettyNpnSslEngine$1;
import pro.gravit.repackage.io.netty.handler.ssl.JettyNpnSslEngine$2;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

final class JettyNpnSslEngine
extends JdkSslEngine {
    private static boolean available;

    static boolean isAvailable() {
        JettyNpnSslEngine.updateAvailability();
        return available;
    }

    private static void updateAvailability() {
        if (available) {
            return;
        }
        try {
            Class.forName("sun.security.ssl.NextProtoNegoExtension", true, null);
            available = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    JettyNpnSslEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl) {
        super(sSLEngine);
        ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator, "applicationNegotiator");
        if (bl) {
            JdkApplicationProtocolNegotiator$ProtocolSelectionListener jdkApplicationProtocolNegotiator$ProtocolSelectionListener = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols()), "protocolListener");
            NextProtoNego.put((SSLEngine)sSLEngine, (NextProtoNego.Provider)new JettyNpnSslEngine$1(this, jdkApplicationProtocolNegotiator$ProtocolSelectionListener, jdkApplicationProtocolNegotiator));
        } else {
            JdkApplicationProtocolNegotiator$ProtocolSelector jdkApplicationProtocolNegotiator$ProtocolSelector = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())), "protocolSelector");
            NextProtoNego.put((SSLEngine)sSLEngine, (NextProtoNego.Provider)new JettyNpnSslEngine$2(this, jdkApplicationProtocolNegotiator$ProtocolSelector));
        }
    }

    @Override
    public void closeInbound() {
        NextProtoNego.remove((SSLEngine)this.getWrappedEngine());
        super.closeInbound();
    }

    @Override
    public void closeOutbound() {
        NextProtoNego.remove((SSLEngine)this.getWrappedEngine());
        super.closeOutbound();
    }
}

