/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.util.HashMap;
import java.util.Map;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslClientSessionCache$HostPort;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslEngineMap;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionCache;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionCache$NativeSslSession;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;

final class OpenSslClientSessionCache
extends OpenSslSessionCache {
    private final Map<OpenSslClientSessionCache$HostPort, OpenSslSessionCache$NativeSslSession> sessions = new HashMap<OpenSslClientSessionCache$HostPort, OpenSslSessionCache$NativeSslSession>();

    OpenSslClientSessionCache(OpenSslEngineMap openSslEngineMap) {
        super(openSslEngineMap);
    }

    @Override
    protected boolean sessionCreated(OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession) {
        assert (Thread.holdsLock(this));
        OpenSslClientSessionCache$HostPort openSslClientSessionCache$HostPort = OpenSslClientSessionCache.keyFor(openSslSessionCache$NativeSslSession.getPeerHost(), openSslSessionCache$NativeSslSession.getPeerPort());
        if (openSslClientSessionCache$HostPort == null || this.sessions.containsKey(openSslClientSessionCache$HostPort)) {
            return false;
        }
        this.sessions.put(openSslClientSessionCache$HostPort, openSslSessionCache$NativeSslSession);
        return true;
    }

    @Override
    protected void sessionRemoved(OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession) {
        assert (Thread.holdsLock(this));
        OpenSslClientSessionCache$HostPort openSslClientSessionCache$HostPort = OpenSslClientSessionCache.keyFor(openSslSessionCache$NativeSslSession.getPeerHost(), openSslSessionCache$NativeSslSession.getPeerPort());
        if (openSslClientSessionCache$HostPort == null) {
            return;
        }
        this.sessions.remove(openSslClientSessionCache$HostPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setSession(long l, String string, int n) {
        boolean bl;
        OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession;
        OpenSslClientSessionCache$HostPort openSslClientSessionCache$HostPort = OpenSslClientSessionCache.keyFor(string, n);
        if (openSslClientSessionCache$HostPort == null) {
            return;
        }
        OpenSslClientSessionCache openSslClientSessionCache = this;
        synchronized (openSslClientSessionCache) {
            openSslSessionCache$NativeSslSession = this.sessions.get(openSslClientSessionCache$HostPort);
            if (openSslSessionCache$NativeSslSession == null) {
                return;
            }
            if (!openSslSessionCache$NativeSslSession.isValid()) {
                this.removeSessionWithId(openSslSessionCache$NativeSslSession.sessionId());
                return;
            }
            bl = SSL.setSession((long)l, (long)openSslSessionCache$NativeSslSession.session());
        }
        if (bl) {
            if (openSslSessionCache$NativeSslSession.shouldBeSingleUse()) {
                openSslSessionCache$NativeSslSession.invalidate();
            }
            openSslSessionCache$NativeSslSession.updateLastAccessedTime();
        }
    }

    private static OpenSslClientSessionCache$HostPort keyFor(String string, int n) {
        if (string == null && n < 1) {
            return null;
        }
        return new OpenSslClientSessionCache$HostPort(string, n);
    }

    @Override
    synchronized void clear() {
        super.clear();
        this.sessions.clear();
    }
}

