/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.traffic;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import pro.gravit.repackage.io.netty.handler.traffic.AbstractTrafficShapingHandler$ReopenReadTimerTask;
import pro.gravit.repackage.io.netty.handler.traffic.GlobalChannelTrafficCounter;
import pro.gravit.repackage.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$1;
import pro.gravit.repackage.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$2;
import pro.gravit.repackage.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$PerChannel;
import pro.gravit.repackage.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$ToSend;
import pro.gravit.repackage.io.netty.handler.traffic.TrafficCounter;
import pro.gravit.repackage.io.netty.util.Attribute;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

@ChannelHandler.Sharable
public class GlobalChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(GlobalChannelTrafficShapingHandler.class);
    final ConcurrentMap<Integer, GlobalChannelTrafficShapingHandler$PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    volatile long maxGlobalWriteSize = 0x19000000L;
    private volatile long writeChannelLimit;
    private volatile long readChannelLimit;
    private static final float DEFAULT_DEVIATION = 0.1f;
    private static final float MAX_DEVIATION = 0.4f;
    private static final float DEFAULT_SLOWDOWN = 0.4f;
    private static final float DEFAULT_ACCELERATION = -0.1f;
    private volatile float maxDeviation;
    private volatile float accelerationFactor;
    private volatile float slowDownFactor;
    private volatile boolean readDeviationActive;
    private volatile boolean writeDeviationActive;

    void createGlobalTrafficCounter(ScheduledExecutorService scheduledExecutorService) {
        this.setMaxDeviation(0.1f, 0.4f, -0.1f);
        ObjectUtil.checkNotNullWithIAE(scheduledExecutorService, "executor");
        GlobalChannelTrafficCounter globalChannelTrafficCounter = new GlobalChannelTrafficCounter(this, scheduledExecutorService, "GlobalChannelTC", this.checkInterval);
        this.setTrafficCounter(globalChannelTrafficCounter);
        ((TrafficCounter)globalChannelTrafficCounter).start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 3;
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l, long l2, long l3, long l4, long l5, long l6) {
        super(l, l2, l5, l6);
        this.createGlobalTrafficCounter(scheduledExecutorService);
        this.writeChannelLimit = l3;
        this.readChannelLimit = l4;
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l, long l2, long l3, long l4, long l5) {
        super(l, l2, l5);
        this.writeChannelLimit = l3;
        this.readChannelLimit = l4;
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l, long l2, long l3, long l4) {
        super(l, l2);
        this.writeChannelLimit = l3;
        this.readChannelLimit = l4;
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l) {
        super(l);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService) {
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public float maxDeviation() {
        return this.maxDeviation;
    }

    public float accelerationFactor() {
        return this.accelerationFactor;
    }

    public float slowDownFactor() {
        return this.slowDownFactor;
    }

    public void setMaxDeviation(float f, float f2, float f3) {
        if (f > 0.4f) {
            throw new IllegalArgumentException("maxDeviation must be <= 0.4");
        }
        ObjectUtil.checkPositiveOrZero(f2, "slowDownFactor");
        if (f3 > 0.0f) {
            throw new IllegalArgumentException("accelerationFactor must be <= 0");
        }
        this.maxDeviation = f;
        this.accelerationFactor = 1.0f + f3;
        this.slowDownFactor = 1.0f + f2;
    }

    private void computeDeviationCumulativeBytes() {
        long l = 0L;
        long l2 = 0L;
        long l3 = Long.MAX_VALUE;
        long l4 = Long.MAX_VALUE;
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            long l5 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeWrittenBytes();
            if (l < l5) {
                l = l5;
            }
            if (l3 > l5) {
                l3 = l5;
            }
            if (l2 < (l5 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeReadBytes())) {
                l2 = l5;
            }
            if (l4 <= l5) continue;
            l4 = l5;
        }
        boolean bl = this.channelQueues.size() > 1;
        this.readDeviationActive = bl && l4 < l2 / 2L;
        this.writeDeviationActive = bl && l3 < l / 2L;
        this.cumulativeWrittenBytes.set(l);
        this.cumulativeReadBytes.set(l2);
    }

    @Override
    protected void doAccounting(TrafficCounter trafficCounter) {
        this.computeDeviationCumulativeBytes();
        super.doAccounting(trafficCounter);
    }

    private long computeBalancedWait(float f, float f2, long l) {
        if (f2 == 0.0f) {
            return l;
        }
        float f3 = f / f2;
        if (f3 > this.maxDeviation) {
            if (f3 < 1.0f - this.maxDeviation) {
                return l;
            }
            f3 = this.slowDownFactor;
            if (l < 10L) {
                l = 10L;
            }
        } else {
            f3 = this.accelerationFactor;
        }
        return (long)((float)l * f3);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long l) {
        this.maxGlobalWriteSize = ObjectUtil.checkPositive(l, "maxGlobalWriteSize");
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public void configureChannel(long l, long l2) {
        this.writeChannelLimit = l;
        this.readChannelLimit = l2;
        long l3 = TrafficCounter.milliSecondFromNano();
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.resetAccounting(l3);
        }
    }

    public long getWriteChannelLimit() {
        return this.writeChannelLimit;
    }

    public void setWriteChannelLimit(long l) {
        this.writeChannelLimit = l;
        long l2 = TrafficCounter.milliSecondFromNano();
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.resetAccounting(l2);
        }
    }

    public long getReadChannelLimit() {
        return this.readChannelLimit;
    }

    public void setReadChannelLimit(long l) {
        this.readChannelLimit = l;
        long l2 = TrafficCounter.milliSecondFromNano();
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.resetAccounting(l2);
        }
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    private GlobalChannelTrafficShapingHandler$PerChannel getOrSetPerChannel(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        Integer n = channel.hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
        if (globalChannelTrafficShapingHandler$PerChannel == null) {
            globalChannelTrafficShapingHandler$PerChannel = new GlobalChannelTrafficShapingHandler$PerChannel();
            globalChannelTrafficShapingHandler$PerChannel.messagesQueue = new ArrayDeque();
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter = new TrafficCounter(this, null, "ChannelTC" + channelHandlerContext.channel().hashCode(), this.checkInterval);
            globalChannelTrafficShapingHandler$PerChannel.queueSize = 0L;
            globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp = globalChannelTrafficShapingHandler$PerChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put(n, globalChannelTrafficShapingHandler$PerChannel);
        }
        return globalChannelTrafficShapingHandler$PerChannel;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.getOrSetPerChannel(channelHandlerContext);
        this.trafficCounter.resetCumulativeTime();
        super.handlerAdded(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.trafficCounter.resetCumulativeTime();
        Channel channel = channelHandlerContext.channel();
        Integer n = channel.hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.remove(n);
        if (globalChannelTrafficShapingHandler$PerChannel != null) {
            GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel2 = globalChannelTrafficShapingHandler$PerChannel;
            synchronized (globalChannelTrafficShapingHandler$PerChannel2) {
                if (channel.isActive()) {
                    for (GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend : globalChannelTrafficShapingHandler$PerChannel.messagesQueue) {
                        long l = this.calculateSize(globalChannelTrafficShapingHandler$ToSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(l);
                        globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.bytesRealWriteFlowControl(l);
                        globalChannelTrafficShapingHandler$PerChannel.queueSize -= l;
                        this.queuesSize.addAndGet(-l);
                        channelHandlerContext.write(globalChannelTrafficShapingHandler$ToSend.toSend, globalChannelTrafficShapingHandler$ToSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-globalChannelTrafficShapingHandler$PerChannel.queueSize);
                    for (GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend : globalChannelTrafficShapingHandler$PerChannel.messagesQueue) {
                        if (!(globalChannelTrafficShapingHandler$ToSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)globalChannelTrafficShapingHandler$ToSend.toSend).release();
                    }
                }
                globalChannelTrafficShapingHandler$PerChannel.messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        long l = this.calculateSize(object);
        long l2 = TrafficCounter.milliSecondFromNano();
        if (l > 0L) {
            long l3 = this.trafficCounter.readTimeToWait(l, this.getReadLimit(), this.maxTime, l2);
            Integer n = channelHandlerContext.channel().hashCode();
            GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
            long l4 = 0L;
            if (globalChannelTrafficShapingHandler$PerChannel != null) {
                l4 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.readTimeToWait(l, this.readChannelLimit, this.maxTime, l2);
                if (this.readDeviationActive) {
                    long l5 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeReadBytes();
                    long l6 = this.cumulativeReadBytes.get();
                    if (l5 <= 0L) {
                        l5 = 0L;
                    }
                    if (l6 < l5) {
                        l6 = l5;
                    }
                    l4 = this.computeBalancedWait(l5, l6, l4);
                }
            }
            if (l4 < l3) {
                l4 = l3;
            }
            if ((l4 = this.checkWaitReadTime(channelHandlerContext, l4, l2)) >= 10L) {
                Channel channel = channelHandlerContext.channel();
                ChannelConfig channelConfig = channel.config();
                if (logger.isDebugEnabled()) {
                    logger.debug("Read Suspend: " + l4 + ':' + channelConfig.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                if (channelConfig.isAutoRead() && GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext)) {
                    channelConfig.setAutoRead(false);
                    channel.attr(READ_SUSPENDED).set(true);
                    Attribute<Runnable> attribute = channel.attr(REOPEN_TASK);
                    Runnable runnable = (Runnable)attribute.get();
                    if (runnable == null) {
                        runnable = new AbstractTrafficShapingHandler$ReopenReadTimerTask(channelHandlerContext);
                        attribute.set(runnable);
                    }
                    channelHandlerContext.executor().schedule(runnable, l4, TimeUnit.MILLISECONDS);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Suspend final status => " + channelConfig.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext) + " will reopened at: " + l4);
                    }
                }
            }
        }
        this.informReadOperation(channelHandlerContext, l2);
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    protected long checkWaitReadTime(ChannelHandlerContext channelHandlerContext, long l, long l2) {
        Integer n = channelHandlerContext.channel().hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
        if (globalChannelTrafficShapingHandler$PerChannel != null && l > this.maxTime && l2 + l - globalChannelTrafficShapingHandler$PerChannel.lastReadTimestamp > this.maxTime) {
            l = this.maxTime;
        }
        return l;
    }

    @Override
    protected void informReadOperation(ChannelHandlerContext channelHandlerContext, long l) {
        Integer n = channelHandlerContext.channel().hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
        if (globalChannelTrafficShapingHandler$PerChannel != null) {
            globalChannelTrafficShapingHandler$PerChannel.lastReadTimestamp = l;
        }
    }

    protected long maximumCumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    protected long maximumCumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public Collection<TrafficCounter> channelTrafficCounters() {
        return new GlobalChannelTrafficShapingHandler$1(this);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        long l = this.calculateSize(object);
        long l2 = TrafficCounter.milliSecondFromNano();
        if (l > 0L) {
            long l3 = this.trafficCounter.writeTimeToWait(l, this.getWriteLimit(), this.maxTime, l2);
            Integer n = channelHandlerContext.channel().hashCode();
            GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
            long l4 = 0L;
            if (globalChannelTrafficShapingHandler$PerChannel != null) {
                l4 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.writeTimeToWait(l, this.writeChannelLimit, this.maxTime, l2);
                if (this.writeDeviationActive) {
                    long l5 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeWrittenBytes();
                    long l6 = this.cumulativeWrittenBytes.get();
                    if (l5 <= 0L) {
                        l5 = 0L;
                    }
                    if (l6 < l5) {
                        l6 = l5;
                    }
                    l4 = this.computeBalancedWait(l5, l6, l4);
                }
            }
            if (l4 < l3) {
                l4 = l3;
            }
            if (l4 >= 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Write suspend: " + l4 + ':' + channelHandlerContext.channel().config().isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                this.submitWrite(channelHandlerContext, object, l, l4, l2, channelPromise);
                return;
            }
        }
        this.submitWrite(channelHandlerContext, object, l, 0L, l2, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void submitWrite(ChannelHandlerContext channelHandlerContext, Object object, long l, long l2, long l3, ChannelPromise channelPromise) {
        GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend;
        Channel channel = channelHandlerContext.channel();
        Integer n = channel.hashCode();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
        if (globalChannelTrafficShapingHandler$PerChannel == null) {
            globalChannelTrafficShapingHandler$PerChannel = this.getOrSetPerChannel(channelHandlerContext);
        }
        long l4 = l2;
        boolean bl = false;
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel2 = globalChannelTrafficShapingHandler$PerChannel;
        synchronized (globalChannelTrafficShapingHandler$PerChannel2) {
            if (l2 == 0L && globalChannelTrafficShapingHandler$PerChannel.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l);
                globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.bytesRealWriteFlowControl(l);
                channelHandlerContext.write(object, channelPromise);
                globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp = l3;
                return;
            }
            if (l4 > this.maxTime && l3 + l4 - globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp > this.maxTime) {
                l4 = this.maxTime;
            }
            globalChannelTrafficShapingHandler$ToSend = new GlobalChannelTrafficShapingHandler$ToSend(l4 + l3, object, l, channelPromise, null);
            globalChannelTrafficShapingHandler$PerChannel.messagesQueue.addLast(globalChannelTrafficShapingHandler$ToSend);
            globalChannelTrafficShapingHandler$PerChannel.queueSize += l;
            this.queuesSize.addAndGet(l);
            this.checkWriteSuspend(channelHandlerContext, l4, globalChannelTrafficShapingHandler$PerChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                bl = true;
            }
        }
        if (bl) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
        long l5 = globalChannelTrafficShapingHandler$ToSend.relativeTimeAction;
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel3 = globalChannelTrafficShapingHandler$PerChannel;
        channelHandlerContext.executor().schedule(new GlobalChannelTrafficShapingHandler$2(this, channelHandlerContext, globalChannelTrafficShapingHandler$PerChannel3, l5), l4, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext channelHandlerContext, GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel, long l) {
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel2 = globalChannelTrafficShapingHandler$PerChannel;
        synchronized (globalChannelTrafficShapingHandler$PerChannel2) {
            GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend = globalChannelTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            while (globalChannelTrafficShapingHandler$ToSend != null) {
                long l2;
                if (globalChannelTrafficShapingHandler$ToSend.relativeTimeAction <= l) {
                    l2 = globalChannelTrafficShapingHandler$ToSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(l2);
                    globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.bytesRealWriteFlowControl(l2);
                    globalChannelTrafficShapingHandler$PerChannel.queueSize -= l2;
                } else {
                    globalChannelTrafficShapingHandler$PerChannel.messagesQueue.addFirst(globalChannelTrafficShapingHandler$ToSend);
                    break;
                }
                this.queuesSize.addAndGet(-l2);
                channelHandlerContext.write(globalChannelTrafficShapingHandler$ToSend.toSend, globalChannelTrafficShapingHandler$ToSend.promise);
                globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp = l;
                globalChannelTrafficShapingHandler$ToSend = globalChannelTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            }
            if (globalChannelTrafficShapingHandler$PerChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    @Override
    public String toString() {
        return new StringBuilder(340).append(super.toString()).append(" Write Channel Limit: ").append(this.writeChannelLimit).append(" Read Channel Limit: ").append(this.readChannelLimit).toString();
    }

    static /* synthetic */ void access$100(GlobalChannelTrafficShapingHandler globalChannelTrafficShapingHandler, ChannelHandlerContext channelHandlerContext, GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel, long l) {
        globalChannelTrafficShapingHandler.sendAllValid(channelHandlerContext, globalChannelTrafficShapingHandler$PerChannel, l);
    }
}

