/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import pro.gravit.repackage.io.netty.util.concurrent.AbstractFuture;
import pro.gravit.repackage.io.netty.util.concurrent.BlockingOperationException;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultFutureListeners;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise$1;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise$2;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise$3;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise$4;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise$CauseHolder;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise$LeanCancellationException;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise$StacklessCancellationException;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.GenericProgressiveFutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.ProgressiveFuture;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.InternalThreadLocalMap;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class DefaultPromise<V>
extends AbstractFuture<V>
implements Promise<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultPromise.class);
    private static final InternalLogger rejectedExecutionLogger = InternalLoggerFactory.getInstance(DefaultPromise.class.getName() + ".rejectedExecution");
    private static final int MAX_LISTENER_STACK_DEPTH = Math.min(8, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.defaultPromise.maxListenerStackDepth", 8));
    private static final AtomicReferenceFieldUpdater<DefaultPromise, Object> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultPromise.class, Object.class, "result");
    private static final Object SUCCESS = new Object();
    private static final Object UNCANCELLABLE = new Object();
    private static final DefaultPromise$CauseHolder CANCELLATION_CAUSE_HOLDER = new DefaultPromise$CauseHolder(DefaultPromise$StacklessCancellationException.newInstance(DefaultPromise.class, "cancel(...)"));
    private static final StackTraceElement[] CANCELLATION_STACK = DefaultPromise.CANCELLATION_CAUSE_HOLDER.cause.getStackTrace();
    private volatile Object result;
    private final EventExecutor executor;
    private GenericFutureListener<? extends Future<?>> listener;
    private DefaultFutureListeners listeners;
    private short waiters;
    private boolean notifyingListeners;

    public DefaultPromise(EventExecutor eventExecutor) {
        this.executor = ObjectUtil.checkNotNull(eventExecutor, "executor");
    }

    protected DefaultPromise() {
        this.executor = null;
    }

    @Override
    public Promise<V> setSuccess(V v) {
        if (this.setSuccess0(v)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this);
    }

    @Override
    public boolean trySuccess(V v) {
        return this.setSuccess0(v);
    }

    @Override
    public Promise<V> setFailure(Throwable throwable) {
        if (this.setFailure0(throwable)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this, throwable);
    }

    @Override
    public boolean tryFailure(Throwable throwable) {
        return this.setFailure0(throwable);
    }

    @Override
    public boolean setUncancellable() {
        if (RESULT_UPDATER.compareAndSet(this, null, UNCANCELLABLE)) {
            return true;
        }
        Object object = this.result;
        return !DefaultPromise.isDone0(object) || !DefaultPromise.isCancelled0(object);
    }

    @Override
    public boolean isSuccess() {
        Object object = this.result;
        return object != null && object != UNCANCELLABLE && !(object instanceof DefaultPromise$CauseHolder);
    }

    @Override
    public boolean isCancellable() {
        return this.result == null;
    }

    @Override
    public Throwable cause() {
        return this.cause0(this.result);
    }

    private Throwable cause0(Object object) {
        if (!(object instanceof DefaultPromise$CauseHolder)) {
            return null;
        }
        if (object == CANCELLATION_CAUSE_HOLDER) {
            DefaultPromise$LeanCancellationException defaultPromise$LeanCancellationException = new DefaultPromise$LeanCancellationException(null);
            if (RESULT_UPDATER.compareAndSet(this, CANCELLATION_CAUSE_HOLDER, new DefaultPromise$CauseHolder(defaultPromise$LeanCancellationException))) {
                return defaultPromise$LeanCancellationException;
            }
            object = this.result;
        }
        return ((DefaultPromise$CauseHolder)object).cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> addListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        ObjectUtil.checkNotNull(genericFutureListener, "listener");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            this.addListener0(genericFutureListener);
        }
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> addListeners(GenericFutureListener<? extends Future<? super V>> ... genericFutureListenerArray) {
        ObjectUtil.checkNotNull(genericFutureListenerArray, "listeners");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            for (GenericFutureListener<? extends Future<? super V>> genericFutureListener : genericFutureListenerArray) {
                if (genericFutureListener == null) break;
                this.addListener0(genericFutureListener);
            }
        }
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> removeListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        ObjectUtil.checkNotNull(genericFutureListener, "listener");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            this.removeListener0(genericFutureListener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> removeListeners(GenericFutureListener<? extends Future<? super V>> ... genericFutureListenerArray) {
        ObjectUtil.checkNotNull(genericFutureListenerArray, "listeners");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            for (GenericFutureListener<? extends Future<? super V>> genericFutureListener : genericFutureListenerArray) {
                if (genericFutureListener == null) break;
                this.removeListener0(genericFutureListener);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> await() {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> awaitUninterruptibly() {
        if (this.isDone()) {
            return this;
        }
        this.checkDeadLock();
        boolean bl = false;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    @Override
    public boolean await(long l, TimeUnit timeUnit) {
        return this.await0(timeUnit.toNanos(l), true);
    }

    @Override
    public boolean await(long l) {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(l), true);
    }

    @Override
    public boolean awaitUninterruptibly(long l, TimeUnit timeUnit) {
        try {
            return this.await0(timeUnit.toNanos(l), false);
        }
        catch (InterruptedException interruptedException) {
            throw new InternalError();
        }
    }

    @Override
    public boolean awaitUninterruptibly(long l) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(l), false);
        }
        catch (InterruptedException interruptedException) {
            throw new InternalError();
        }
    }

    @Override
    public V getNow() {
        Object object = this.result;
        if (object instanceof DefaultPromise$CauseHolder || object == SUCCESS || object == UNCANCELLABLE) {
            return null;
        }
        return (V)object;
    }

    @Override
    public V get() {
        Object object = this.result;
        if (!DefaultPromise.isDone0(object)) {
            this.await();
            object = this.result;
        }
        if (object == SUCCESS || object == UNCANCELLABLE) {
            return null;
        }
        Throwable throwable = this.cause0(object);
        if (throwable == null) {
            return (V)object;
        }
        if (throwable instanceof CancellationException) {
            throw (CancellationException)throwable;
        }
        throw new ExecutionException(throwable);
    }

    @Override
    public V get(long l, TimeUnit timeUnit) {
        Object object = this.result;
        if (!DefaultPromise.isDone0(object)) {
            if (!this.await(l, timeUnit)) {
                throw new TimeoutException();
            }
            object = this.result;
        }
        if (object == SUCCESS || object == UNCANCELLABLE) {
            return null;
        }
        Throwable throwable = this.cause0(object);
        if (throwable == null) {
            return (V)object;
        }
        if (throwable instanceof CancellationException) {
            throw (CancellationException)throwable;
        }
        throw new ExecutionException(throwable);
    }

    @Override
    public boolean cancel(boolean bl) {
        if (RESULT_UPDATER.compareAndSet(this, null, CANCELLATION_CAUSE_HOLDER)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return DefaultPromise.isCancelled0(this.result);
    }

    @Override
    public boolean isDone() {
        return DefaultPromise.isDone0(this.result);
    }

    @Override
    public Promise<V> sync() {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    @Override
    public Promise<V> syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed();
        return this;
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(64).append(StringUtil.simpleClassName(this)).append('@').append(Integer.toHexString(this.hashCode()));
        Object object = this.result;
        if (object == SUCCESS) {
            stringBuilder.append("(success)");
        } else if (object == UNCANCELLABLE) {
            stringBuilder.append("(uncancellable)");
        } else if (object instanceof DefaultPromise$CauseHolder) {
            stringBuilder.append("(failure: ").append(((DefaultPromise$CauseHolder)object).cause).append(')');
        } else if (object != null) {
            stringBuilder.append("(success: ").append(object).append(')');
        } else {
            stringBuilder.append("(incomplete)");
        }
        return stringBuilder;
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    protected void checkDeadLock() {
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor != null && eventExecutor.inEventLoop()) {
            throw new BlockingOperationException(this.toString());
        }
    }

    protected static void notifyListener(EventExecutor eventExecutor, Future<?> future, GenericFutureListener<?> genericFutureListener) {
        DefaultPromise.notifyListenerWithStackOverFlowProtection(ObjectUtil.checkNotNull(eventExecutor, "eventExecutor"), ObjectUtil.checkNotNull(future, "future"), ObjectUtil.checkNotNull(genericFutureListener, "listener"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        InternalThreadLocalMap internalThreadLocalMap;
        int n;
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor.inEventLoop() && (n = (internalThreadLocalMap = InternalThreadLocalMap.get()).futureListenerStackDepth()) < MAX_LISTENER_STACK_DEPTH) {
            internalThreadLocalMap.setFutureListenerStackDepth(n + 1);
            try {
                this.notifyListenersNow();
            }
            finally {
                internalThreadLocalMap.setFutureListenerStackDepth(n);
            }
            return;
        }
        DefaultPromise.safeExecute(eventExecutor, new DefaultPromise$1(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListenerWithStackOverFlowProtection(EventExecutor eventExecutor, Future<?> future, GenericFutureListener<?> genericFutureListener) {
        InternalThreadLocalMap internalThreadLocalMap;
        int n;
        if (eventExecutor.inEventLoop() && (n = (internalThreadLocalMap = InternalThreadLocalMap.get()).futureListenerStackDepth()) < MAX_LISTENER_STACK_DEPTH) {
            internalThreadLocalMap.setFutureListenerStackDepth(n + 1);
            try {
                DefaultPromise.notifyListener0(future, genericFutureListener);
            }
            finally {
                internalThreadLocalMap.setFutureListenerStackDepth(n);
            }
            return;
        }
        DefaultPromise.safeExecute(eventExecutor, new DefaultPromise$2(future, genericFutureListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersNow() {
        DefaultFutureListeners defaultFutureListeners;
        GenericFutureListener<? extends Future<?>> genericFutureListener;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            genericFutureListener = this.listener;
            defaultFutureListeners = this.listeners;
            if (this.notifyingListeners || genericFutureListener == null && defaultFutureListeners == null) {
                return;
            }
            this.notifyingListeners = true;
            if (genericFutureListener != null) {
                this.listener = null;
            } else {
                this.listeners = null;
            }
        }
        while (true) {
            if (genericFutureListener != null) {
                DefaultPromise.notifyListener0(this, genericFutureListener);
            } else {
                this.notifyListeners0(defaultFutureListeners);
            }
            defaultPromise = this;
            synchronized (defaultPromise) {
                if (this.listener == null && this.listeners == null) {
                    this.notifyingListeners = false;
                    return;
                }
                genericFutureListener = this.listener;
                defaultFutureListeners = this.listeners;
                if (genericFutureListener != null) {
                    this.listener = null;
                } else {
                    this.listeners = null;
                }
            }
        }
    }

    private void notifyListeners0(DefaultFutureListeners defaultFutureListeners) {
        GenericFutureListener<? extends Future<?>>[] genericFutureListenerArray = defaultFutureListeners.listeners();
        int n = defaultFutureListeners.size();
        for (int i = 0; i < n; ++i) {
            DefaultPromise.notifyListener0(this, genericFutureListenerArray[i]);
        }
    }

    private static void notifyListener0(Future future, GenericFutureListener genericFutureListener) {
        block2: {
            try {
                genericFutureListener.operationComplete(future);
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + genericFutureListener.getClass().getName() + ".operationComplete()", throwable);
            }
        }
    }

    private void addListener0(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        if (this.listener == null) {
            if (this.listeners == null) {
                this.listener = genericFutureListener;
            } else {
                this.listeners.add(genericFutureListener);
            }
        } else {
            assert (this.listeners == null);
            this.listeners = new DefaultFutureListeners(this.listener, genericFutureListener);
            this.listener = null;
        }
    }

    private void removeListener0(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        if (this.listener == genericFutureListener) {
            this.listener = null;
        } else if (this.listeners != null) {
            this.listeners.remove(genericFutureListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    private boolean setSuccess0(V v) {
        return this.setValue0(v == null ? SUCCESS : v);
    }

    private boolean setFailure0(Throwable throwable) {
        return this.setValue0(new DefaultPromise$CauseHolder(ObjectUtil.checkNotNull(throwable, "cause")));
    }

    private boolean setValue0(Object object) {
        if (RESULT_UPDATER.compareAndSet(this, null, object) || RESULT_UPDATER.compareAndSet(this, UNCANCELLABLE, object)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    private synchronized boolean checkNotifyWaiters() {
        if (this.waiters > 0) {
            this.notifyAll();
        }
        return this.listener != null || this.listeners != null;
    }

    private void incWaiters() {
        if (this.waiters == Short.MAX_VALUE) {
            throw new IllegalStateException("too many waiters: " + this);
        }
        this.waiters = (short)(this.waiters + 1);
    }

    private void decWaiters() {
        this.waiters = (short)(this.waiters - 1);
    }

    private void rethrowIfFailed() {
        Throwable throwable = this.cause();
        if (throwable == null) {
            return;
        }
        PlatformDependent.throwException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long l, boolean bl) {
        if (this.isDone()) {
            return true;
        }
        if (l <= 0L) {
            return this.isDone();
        }
        if (bl && Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        long l2 = System.nanoTime();
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            boolean bl2 = false;
            try {
                long l3 = l;
                while (!this.isDone() && l3 > 0L) {
                    this.incWaiters();
                    try {
                        this.wait(l3 / 1000000L, (int)(l3 % 1000000L));
                    }
                    catch (InterruptedException interruptedException) {
                        if (bl) {
                            throw interruptedException;
                        }
                        bl2 = true;
                    }
                    finally {
                        this.decWaiters();
                    }
                    if (this.isDone()) {
                        boolean bl3 = true;
                        return bl3;
                    }
                    l3 = l - (System.nanoTime() - l2);
                }
                boolean bl4 = this.isDone();
                return bl4;
            }
            finally {
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    void notifyProgressiveListeners(long l, long l2) {
        Object object = this.progressiveListeners();
        if (object == null) {
            return;
        }
        ProgressiveFuture progressiveFuture = (ProgressiveFuture)((Object)this);
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor.inEventLoop()) {
            if (object instanceof GenericProgressiveFutureListener[]) {
                DefaultPromise.notifyProgressiveListeners0(progressiveFuture, (GenericProgressiveFutureListener[])object, l, l2);
            } else {
                DefaultPromise.notifyProgressiveListener0(progressiveFuture, (GenericProgressiveFutureListener)object, l, l2);
            }
        } else if (object instanceof GenericProgressiveFutureListener[]) {
            GenericProgressiveFutureListener[] genericProgressiveFutureListenerArray = (GenericProgressiveFutureListener[])object;
            DefaultPromise.safeExecute(eventExecutor, new DefaultPromise$3(this, progressiveFuture, genericProgressiveFutureListenerArray, l, l2));
        } else {
            GenericProgressiveFutureListener genericProgressiveFutureListener = (GenericProgressiveFutureListener)object;
            DefaultPromise.safeExecute(eventExecutor, new DefaultPromise$4(this, progressiveFuture, genericProgressiveFutureListener, l, l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Object progressiveListeners() {
        GenericFutureListener<? extends Future<?>> genericFutureListener = this.listener;
        DefaultFutureListeners defaultFutureListeners = this.listeners;
        if (genericFutureListener == null && defaultFutureListeners == null) {
            return null;
        }
        if (defaultFutureListeners != null) {
            void var8_13;
            DefaultFutureListeners defaultFutureListeners2 = defaultFutureListeners;
            int n = defaultFutureListeners2.progressiveSize();
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    for (GenericFutureListener<Future<?>> genericFutureListener2 : defaultFutureListeners2.listeners()) {
                        if (!(genericFutureListener2 instanceof GenericProgressiveFutureListener)) continue;
                        return genericFutureListener2;
                    }
                    return null;
                }
            }
            GenericFutureListener<? extends Future<?>>[] genericFutureListenerArray = defaultFutureListeners2.listeners();
            GenericProgressiveFutureListener[] genericProgressiveFutureListenerArray = new GenericProgressiveFutureListener[n];
            int n2 = 0;
            boolean n3 = false;
            while (var8_13 < n) {
                GenericFutureListener<Future<?>> genericFutureListener2 = genericFutureListenerArray[n2];
                if (genericFutureListener2 instanceof GenericProgressiveFutureListener) {
                    genericProgressiveFutureListenerArray[++var8_13] = (GenericProgressiveFutureListener)genericFutureListener2;
                }
                ++n2;
            }
            return genericProgressiveFutureListenerArray;
        }
        if (genericFutureListener instanceof GenericProgressiveFutureListener) {
            return genericFutureListener;
        }
        return null;
    }

    private static void notifyProgressiveListeners0(ProgressiveFuture<?> progressiveFuture, GenericProgressiveFutureListener<?>[] genericProgressiveFutureListenerArray, long l, long l2) {
        for (GenericProgressiveFutureListener<?> genericProgressiveFutureListener : genericProgressiveFutureListenerArray) {
            if (genericProgressiveFutureListener == null) break;
            DefaultPromise.notifyProgressiveListener0(progressiveFuture, genericProgressiveFutureListener, l, l2);
        }
    }

    private static void notifyProgressiveListener0(ProgressiveFuture progressiveFuture, GenericProgressiveFutureListener genericProgressiveFutureListener, long l, long l2) {
        block2: {
            try {
                genericProgressiveFutureListener.operationProgressed(progressiveFuture, l, l2);
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + genericProgressiveFutureListener.getClass().getName() + ".operationProgressed()", throwable);
            }
        }
    }

    private static boolean isCancelled0(Object object) {
        return object instanceof DefaultPromise$CauseHolder && ((DefaultPromise$CauseHolder)object).cause instanceof CancellationException;
    }

    private static boolean isDone0(Object object) {
        return object != null && object != UNCANCELLABLE;
    }

    private static void safeExecute(EventExecutor eventExecutor, Runnable runnable) {
        try {
            eventExecutor.execute(runnable);
        }
        catch (Throwable throwable) {
            rejectedExecutionLogger.error("Failed to submit a listener notification task. Event loop shut down?", throwable);
        }
    }

    static /* synthetic */ StackTraceElement[] access$000() {
        return CANCELLATION_STACK;
    }

    static /* synthetic */ void access$200(DefaultPromise defaultPromise) {
        defaultPromise.notifyListenersNow();
    }

    static /* synthetic */ void access$300(Future future, GenericFutureListener genericFutureListener) {
        DefaultPromise.notifyListener0(future, genericFutureListener);
    }

    static /* synthetic */ void access$400(ProgressiveFuture progressiveFuture, GenericProgressiveFutureListener[] genericProgressiveFutureListenerArray, long l, long l2) {
        DefaultPromise.notifyProgressiveListeners0(progressiveFuture, genericProgressiveFutureListenerArray, l, l2);
    }

    static /* synthetic */ void access$500(ProgressiveFuture progressiveFuture, GenericProgressiveFutureListener genericProgressiveFutureListener, long l, long l2) {
        DefaultPromise.notifyProgressiveListener0(progressiveFuture, genericProgressiveFutureListener, l, l2);
    }
}

