/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.concurrent;

import java.util.Queue;
import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.util.concurrent.AbstractEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.FailedFuture;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GlobalEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.ImmediateEventExecutor$1;
import pro.gravit.repackage.io.netty.util.concurrent.ImmediateEventExecutor$2;
import pro.gravit.repackage.io.netty.util.concurrent.ImmediateEventExecutor$ImmediateProgressivePromise;
import pro.gravit.repackage.io.netty.util.concurrent.ImmediateEventExecutor$ImmediatePromise;
import pro.gravit.repackage.io.netty.util.concurrent.ProgressivePromise;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ImmediateEventExecutor
extends AbstractEventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ImmediateEventExecutor.class);
    public static final ImmediateEventExecutor INSTANCE = new ImmediateEventExecutor();
    private static final FastThreadLocal<Queue<Runnable>> DELAYED_RUNNABLES = new ImmediateEventExecutor$1();
    private static final FastThreadLocal<Boolean> RUNNING = new ImmediateEventExecutor$2();
    private final Future<?> terminationFuture = new FailedFuture(GlobalEventExecutor.INSTANCE, new UnsupportedOperationException());

    private ImmediateEventExecutor() {
    }

    @Override
    public boolean inEventLoop() {
        return true;
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return true;
    }

    @Override
    public Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        ObjectUtil.checkNotNull(runnable, "command");
        if (!RUNNING.get().booleanValue()) {
            RUNNING.set(true);
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                logger.info("Throwable caught while executing Runnable {}", (Object)runnable, (Object)throwable);
            }
            finally {
                Runnable runnable2;
                Queue<Runnable> queue = DELAYED_RUNNABLES.get();
                while ((runnable2 = queue.poll()) != null) {
                    try {
                        runnable2.run();
                    }
                    catch (Throwable throwable) {
                        logger.info("Throwable caught while executing Runnable {}", (Object)runnable2, (Object)throwable);
                    }
                }
                RUNNING.set(false);
            }
        } else {
            DELAYED_RUNNABLES.get().add(runnable);
        }
    }

    @Override
    public <V> Promise<V> newPromise() {
        return new ImmediateEventExecutor$ImmediatePromise(this);
    }

    @Override
    public <V> ProgressivePromise<V> newProgressivePromise() {
        return new ImmediateEventExecutor$ImmediateProgressivePromise(this);
    }
}

