/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues;

import java.util.Iterator;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueue$WeakIterator;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.LinkedArrayQueueUtil;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Supplier;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();
    private static final Object BUFFER_CONSUMED = new Object();
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;
    private static final int QUEUE_RESIZE = 3;

    public BaseMpscLinkedArrayQueue(int n) {
        RangeUtil.checkGreaterThanOrEqual(n, 2, "initialCapacity");
        int n2 = Pow2.roundToPowerOfTwo(n);
        long l = n2 - 1 << 1;
        E[] EArray = UnsafeRefArrayAccess.allocateRefArray(n2 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l;
        this.consumerBuffer = EArray;
        this.consumerMask = l;
        this.soProducerLimit(l);
    }

    @Override
    public int size() {
        long l;
        long l2;
        long l3 = this.lvConsumerIndex();
        do {
            l2 = l3;
            l = this.lvProducerIndex();
        } while (l2 != (l3 = this.lvConsumerIndex()));
        long l4 = l - l3 >> 1;
        if (l4 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l4;
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e) {
        Object[] objectArray;
        long l;
        long l2;
        long l3;
        if (null == e) {
            throw new NullPointerException();
        }
        block6: while (true) {
            l3 = this.lvProducerLimit();
            l2 = this.lvProducerIndex();
            if ((l2 & 1L) == 1L) continue;
            l = this.producerMask;
            objectArray = this.producerBuffer;
            if (l3 <= l2) {
                int n = this.offerSlowPath(l, l2, l3);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l, objectArray, l2, e, null);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l2, l2 + 2L)) break;
        }
        l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l);
        UnsafeRefArrayAccess.soRefElement(objectArray, l3, e);
        return true;
    }

    @Override
    public E poll() {
        long l;
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3);
        if (object == null) {
            if (l2 != this.lvProducerIndex()) {
                while ((object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3)) == null) {
                }
            } else {
                return null;
            }
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.nextBuffer(objectArray, l);
            return (E)this.newBufferPoll(objectArray2, l2);
        }
        UnsafeRefArrayAccess.soRefElement(objectArray, l3, null);
        this.soConsumerIndex(l2 + 2L);
        return (E)object;
    }

    @Override
    public E peek() {
        long l;
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3);
        if (object == null && l2 != this.lvProducerIndex()) {
            while ((object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3)) == null) {
            }
        }
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.nextBuffer(objectArray, l), l2);
        }
        return (E)object;
    }

    private int offerSlowPath(long l, long l2, long l3) {
        long l4;
        long l5 = this.lvConsumerIndex();
        if (l5 + (l4 = this.getCurrentBufferCapacity(l)) > l2) {
            if (!this.casProducerLimit(l3, l5 + l4)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(l2, l5) <= 0L) {
            return 2;
        }
        if (this.casProducerIndex(l2, l2 + 1L)) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private E[] nextBuffer(E[] EArray, long l) {
        long l2 = BaseMpscLinkedArrayQueue.nextArrayOffset(l);
        Object[] objectArray = (Object[])UnsafeRefArrayAccess.lvRefElement(EArray, l2);
        this.consumerBuffer = objectArray;
        this.consumerMask = LinkedArrayQueueUtil.length(objectArray) - 2 << 1;
        UnsafeRefArrayAccess.soRefElement(EArray, l2, BUFFER_CONSUMED);
        return objectArray;
    }

    private static long nextArrayOffset(long l) {
        return LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] EArray, long l) {
        long l2 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l, this.consumerMask);
        E e = UnsafeRefArrayAccess.lvRefElement(EArray, l2);
        if (e == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soRefElement(EArray, l2, null);
        this.soConsumerIndex(l + 2L);
        return e;
    }

    private E newBufferPeek(E[] EArray, long l) {
        long l2 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l, this.consumerMask);
        E e = UnsafeRefArrayAccess.lvRefElement(EArray, l2);
        if (null == e) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        long l;
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3);
        if (object == null) {
            return null;
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.nextBuffer(objectArray, l);
            return (E)this.newBufferPoll(objectArray2, l2);
        }
        UnsafeRefArrayAccess.soRefElement(objectArray, l3, null);
        this.soConsumerIndex(l2 + 2L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        long l;
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.lpConsumerIndex();
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l = this.consumerMask);
        Object object = UnsafeRefArrayAccess.lvRefElement(objectArray, l3);
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.nextBuffer(objectArray, l), l2);
        }
        return (E)object;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        int n;
        long l = 0L;
        int n2 = this.capacity();
        do {
            if ((n = this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l;
        } while ((l += (long)n) <= (long)n2);
        return (int)l;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, int n) {
        long l;
        Object[] objectArray;
        long l2;
        long l3;
        if (null == messagePassingQueue$Supplier) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        block5: while (true) {
            long l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            objectArray = this.producerBuffer;
            l = Math.min(l4, l3 + 2L * (long)n);
            if (l3 >= l4) {
                int n2 = this.offerSlowPath(l2, l3, l4);
                switch (n2) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l2, objectArray, l3, null, messagePassingQueue$Supplier);
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l3, l)) break;
        }
        int n3 = (int)((l - l3) / 2L);
        for (int i = 0; i < n3; ++i) {
            long l5 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l3 + 2L * (long)i, l2);
            UnsafeRefArrayAccess.soRefElement(objectArray, l5, messagePassingQueue$Supplier.get());
        }
        return n3;
    }

    @Override
    public void fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, messagePassingQueue$Supplier, waitStrategy, exitCondition);
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer) {
        return this.drain(messagePassingQueue$Consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, int n) {
        return MessagePassingQueueUtil.drain(this, messagePassingQueue$Consumer, n);
    }

    @Override
    public void drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, messagePassingQueue$Consumer, waitStrategy, exitCondition);
    }

    @Override
    public Iterator<E> iterator() {
        return new BaseMpscLinkedArrayQueue$WeakIterator<Object>(this.consumerBuffer, this.lvConsumerIndex(), this.lvProducerIndex());
    }

    private void resize(long l, E[] EArray, long l2, E e, MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        E[] EArray2;
        assert (e != null && messagePassingQueue$Supplier == null || e == null || messagePassingQueue$Supplier != null);
        int n = this.getNextBufferSize(EArray);
        try {
            EArray2 = UnsafeRefArrayAccess.allocateRefArray(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            assert (this.lvProducerIndex() == l2 + 1L);
            this.soProducerIndex(l2);
            throw outOfMemoryError;
        }
        this.producerBuffer = EArray2;
        int n2 = n - 2 << 1;
        this.producerMask = n2;
        long l3 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, l);
        long l4 = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(l2, n2);
        UnsafeRefArrayAccess.soRefElement(EArray2, l4, e == null ? messagePassingQueue$Supplier.get() : e);
        UnsafeRefArrayAccess.soRefElement(EArray, BaseMpscLinkedArrayQueue.nextArrayOffset(l), EArray2);
        long l5 = this.lvConsumerIndex();
        long l6 = this.availableInQueue(l2, l5);
        RangeUtil.checkPositive(l6, "availableInQueue");
        this.soProducerLimit(l2 + Math.min((long)n2, l6));
        this.soProducerIndex(l2 + 2L);
        UnsafeRefArrayAccess.soRefElement(EArray, l3, JUMP);
    }

    protected abstract int getNextBufferSize(E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    static /* synthetic */ Object access$000() {
        return JUMP;
    }

    static /* synthetic */ Object access$100() {
        return BUFFER_CONSUMED;
    }
}

