/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues;

import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$ExitCondition;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Supplier;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$WaitStrategy;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;

public final class MessagePassingQueueUtil {
    public static <E> int drain(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, int n) {
        E e;
        int n2;
        if (null == messagePassingQueue$Consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative: " + n);
        }
        if (n == 0) {
            return 0;
        }
        for (n2 = 0; n2 < n && (e = messagePassingQueue.relaxedPoll()) != null; ++n2) {
            messagePassingQueue$Consumer.accept(e);
        }
        return n2;
    }

    public static <E> int drain(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer) {
        E e;
        if (null == messagePassingQueue$Consumer) {
            throw new IllegalArgumentException("c is null");
        }
        int n = 0;
        while ((e = messagePassingQueue.relaxedPoll()) != null) {
            ++n;
            messagePassingQueue$Consumer.accept(e);
        }
        return n;
    }

    public static <E> void drain(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        if (null == messagePassingQueue$Consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (null == messagePassingQueue$WaitStrategy) {
            throw new IllegalArgumentException("wait is null");
        }
        if (null == messagePassingQueue$ExitCondition) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int n = 0;
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            E e = messagePassingQueue.relaxedPoll();
            if (e == null) {
                n = messagePassingQueue$WaitStrategy.idle(n);
                continue;
            }
            n = 0;
            messagePassingQueue$Consumer.accept(e);
        }
    }

    public static <E> void fill(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        if (null == messagePassingQueue$WaitStrategy) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (null == messagePassingQueue$ExitCondition) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int n = 0;
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            if (messagePassingQueue.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                n = messagePassingQueue$WaitStrategy.idle(n);
                continue;
            }
            n = 0;
        }
    }

    public static <E> int fillBounded(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(messagePassingQueue, messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH, messagePassingQueue.capacity());
    }

    public static <E> int fillInBatchesToLimit(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, int n, int n2) {
        int n3;
        long l = 0L;
        do {
            if ((n3 = messagePassingQueue.fill(messagePassingQueue$Supplier, n)) != 0) continue;
            return (int)l;
        } while ((l += (long)n3) <= (long)n2);
        return (int)l;
    }

    public static <E> int fillUnbounded(MessagePassingQueue<E> messagePassingQueue, MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        return MessagePassingQueueUtil.fillInBatchesToLimit(messagePassingQueue, messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH, 4096);
    }
}

